package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformPilotCityManagementDao;
import com.artfess.reform.fill.manager.*;
import com.artfess.reform.fill.model.*;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class BizReformPilotCityManagementManagerImpl extends BaseManagerImpl<BizReformPilotCityManagementDao, BizReformPilotCityManagement> implements BizReformPilotCityManagementManager {
    @Resource
    UniversalWayManager universalWayManager;
    @Resource
    BizPilotAdvanceCityRecordManager bizPilotAdvanceCityRecordManager;
    @Resource
    BizPilotAdvanceCityResultManager bizPilotAdvanceCityResultManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    BizReformIteratePilotManagementManager bizReformIteratePilotManagementManager;


    @Override
    @Transactional
    public String updateIterateInfo(BizReformPilotCityManagement bizReformPilotCityManagement) {
        Assert.notNull(bizReformPilotCityManagement.getId(),"需修改的项目id不能为空");
        String id = bizReformPilotCityManagement.getId();
        //判断验收时间
        BizReformPilotCityManagement entity = super.getById(id);
        if (entity!=null){
            if (bizReformPilotCityManagement.getIterTimePeriod().equals(entity.getTimePeriod())&&(bizReformPilotCityManagement.getIterAcceptanceTime()!=null&&bizReformPilotCityManagement.getIterAcceptanceTime().equals(entity.getAcceptanceTime()))){
                throw new BaseException("需修改时间与当前项目结束时间一致!!!");
            }
            BizReformIteratePilotManagement iterEntity=new BizReformIteratePilotManagement();
            //更新迭代表
            iterEntity.setPilotId(id);
            iterEntity.setIterateType(0);
            iterEntity.setPilotType(1);
            iterEntity.setStatus(bizReformPilotCityManagement.getStatus());
            iterEntity.setId(null);
            iterEntity.setClassified(bizReformPilotCityManagement.getIterClassified());
            iterEntity.setIterateCause(bizReformPilotCityManagement.getCause());
            iterEntity.setTimePeriod(bizReformPilotCityManagement.getTimePeriod());
            iterEntity.setAcceptanceTime(bizReformPilotCityManagement.getAcceptanceTime());
            iterEntity.setIterTimePeriod(bizReformPilotCityManagement.getIterTimePeriod());
            iterEntity.setIterAcceptanceTime(bizReformPilotCityManagement.getIterAcceptanceTime());
            iterEntity.setPilotProjectName(bizReformPilotCityManagement.getPilotProjectName());
            bizReformIteratePilotManagementManager.saveOrUpdate(iterEntity);
            bizReformIteratePilotManagementManager.setApprovalLog(iterEntity,null);
            List<String> fileIds = bizReformPilotCityManagement.getIterFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
            if (null!=fileIds&&fileIds.size()>0)universalWayManager.attachmentUpdates(fileIds,iterEntity.getId());
            return iterEntity.getId();
        }
        return "";
    }

    @Override
    @Transactional
    public boolean saveOrUpdateInfo(BizReformPilotCityManagement bizReformPilotCityManagement) {
        Assert.notNull(bizReformPilotCityManagement,"对象不能为空");
        Assert.notNull(bizReformPilotCityManagement.getRecord(),"推进信息不能为空");
        BizPilotAdvanceCityRecord record = bizReformPilotCityManagement.getRecord();
        String docNo = bizReformPilotCityManagement.getDocName().replaceAll(" ", "") + "【" + bizReformPilotCityManagement.getDocYear() + "】" + bizReformPilotCityManagement.getDocNum() + "号";
        bizReformPilotCityManagement.setDocNo(docNo);
        if(bizReformPilotCityManagement.getTimePeriod()==0){
            bizReformPilotCityManagement.setAcceptanceTime(null);
        }
        boolean res = super.saveOrUpdate(bizReformPilotCityManagement);
        //上传基本信息附件
        if (bizReformPilotCityManagement.getFiles()!=null&&bizReformPilotCityManagement.getFiles().size()>0){
            List<String> fileIds = bizReformPilotCityManagement.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
            universalWayManager.attachmentUpdates(fileIds,bizReformPilotCityManagement.getId());
        }

        record.setPilotId(bizReformPilotCityManagement.getId());

        List<String> fileIds=null;
        if (BeanUtils.isNotEmpty(record.getFiles())) {
            //当再次更新时,生成新的附件
            fileIds = record.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
            if (BeanUtils.isEmpty(record.getId())){
                List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().in("ID_", fileIds));
                for (DefaultFile file : files) {
                    //将之前数据重新复制一份
                    if (BeanUtils.isNotEmpty(file.getBizId())) {
                        file.setId(null);
                        fileManager.save(file);
                    }
                }
            }
        }
        //判断是否满足记录操作日志条件
        BizPilotAdvanceCityRecord oldRecord = bizPilotAdvanceCityRecordManager.getById(record.getId());
        if (record.getPropulsiveStatus()!=3) record.setActualTime(null);
        if (oldRecord==null){
            bizPilotAdvanceCityRecordManager.saveOrUpdate(bizReformPilotCityManagement.getRecord());
            setApprovalLog(bizReformPilotCityManagement.getRecord());
        }else {
            if (record.getId()==null||oldRecord.getStatus()!=record.getStatus()) setApprovalLog(bizReformPilotCityManagement.getRecord());
            //录入推进信息
            bizPilotAdvanceCityRecordManager.saveOrUpdate(bizReformPilotCityManagement.getRecord());
        }
        //上传推进信息验收材料附件
        if (BeanUtils.isNotEmpty(fileIds)){
            universalWayManager.attachmentUpdates(fileIds,record.getId());
        }
        //录入试点成果信息
        if (record.getResults()!=null&&record.getResults().size()>0){

            List<BizPilotAdvanceCityResult> results = record.getResults();
            results.stream().forEach(p->{
                //根据试点成果查询附件，并根据biz_id来获取附件是否存在关联
                List<String> recFileIds=null;
                if(p.getFiles()!=null&&p.getFiles().size()>0) {
                     recFileIds = p.getFiles().stream().map(DefaultFile::getId).collect(Collectors.toList());
                    if (BeanUtils.isEmpty(p.getId())){
                        List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().in("ID_",recFileIds));
                        for (DefaultFile file : files) {
                            //将之前数据重新复制一份
                            if (BeanUtils.isNotEmpty(file.getBizId())){
                                file.setId(null);
                                fileManager.save(file);
                            }
                        }
                    }
                }

                p.setPilotId(bizReformPilotCityManagement.getId());
                p.setRecordId(record.getId());
                bizPilotAdvanceCityResultManager.saveOrUpdate(p);
                if(recFileIds!=null&&recFileIds.size()>0) {
                    universalWayManager.attachmentUpdates(recFileIds, p.getId());
                }
            });
        }
        return res;
    }

    @Override
    public boolean isSameExists(String id,String docNo) {
        Assert.notNull(docNo,"需要验证的文号不能为空");
        BizReformPilotCityManagement entity = super.getOne(new QueryWrapper<BizReformPilotCityManagement>()
                .eq("DOC_NO_",docNo)
                .eq("IS_DELE_", "0"),false);
        if (BeanUtils.isNotEmpty(entity)){
            return BeanUtils.isNotEmpty(id) && id.equals(entity.getId());
        }
        return true;
    }


    @Override
    @Transactional
    public void deleteInfo(String ids,boolean isAffirm) {
        Assert.notNull(ids,"需要删除的数据不能为空");
        List<String> idList = Arrays.asList(ids.split(","));
        idList.stream().forEach(p->{
            if (!isAffirm){
                int num = bizPilotAdvanceCityRecordManager.count(new QueryWrapper<BizPilotAdvanceCityRecord>().eq("PILOT_ID_", p).eq("IS_DELE_", "0").last("AND STATUS_ >1"));
                if (num>0) throw new BaseException("试点项目中存在已被审核员审核过数据!");
            }
            super.remove(new QueryWrapper<BizReformPilotCityManagement>()
                    .eq("IS_DELE_", "0")
                    .eq("ID_", p));
            //删除相关推进信息和试点成果
            bizPilotAdvanceCityRecordManager.remove(new QueryWrapper<BizPilotAdvanceCityRecord>().eq("PILOT_ID_",p).eq("IS_DELE_","0"));
            //删除试点成果信息
            bizPilotAdvanceCityResultManager.remove(new QueryWrapper<BizPilotAdvanceCityResult>().eq("PILOT_ID_",p).eq("IS_DELE_","0"));
        });
    }

    @Override
    @Transactional
    public boolean updateByStatus(BizPilotAdvanceCityRecord entity) {
        Assert.notNull(entity.getId(),"需要修改的项目id不能为空");
        Assert.notNull(entity.getStatus(),"需要修改的审核状态不能为空");

        BizPilotAdvanceCityRecord oldRecord = bizPilotAdvanceCityRecordManager.getById(entity.getId());
        if (!oldRecord.getStatus().equals(entity.getStatus())) setApprovalLog(entity);
        UpdateWrapper<BizPilotAdvanceCityRecord> updateWrapper=new UpdateWrapper<>();
        updateWrapper.set("STATUS_",entity.getStatus());
        updateWrapper.eq("ID_",entity.getId()).eq("IS_DELE_","0");
        return  bizPilotAdvanceCityRecordManager.update(updateWrapper);
    }

    @Override
    public PageList<BizReformPilotCityManagement> queryPage(QueryFilter<BizReformPilotCityManagement> queryFilter, boolean isAffirm) {
        if (!ContextUtil.getCurrentUser().isAdmin()&&!isAffirm){
            queryFilter.addFilter("M.CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("M.IS_DELE_","0",QueryOP.EQUAL);
        IPage<BizReformPilotCityManagement> iPage = baseMapper.queryPageInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizReformPilotCityManagement> queryGroupPage(QueryFilter<BizReformPilotCityManagement> queryFilter) {
        if (!ContextUtil.getCurrentUser().isAdmin()){
            queryFilter.addFilter("M.UNIT_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        queryFilter.addFilter("M.IS_DELE_","0",QueryOP.EQUAL);
        IPage<BizReformPilotCityManagement> iPage = baseMapper.queryPageInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public void pilotExport(HttpServletResponse response, QueryFilter<BizReformPilotCityManagement> queryFilter) throws Exception {
        List<Map<String, Object>> list = new ArrayList<>();
        List<BizReformPilotCityManagement> models = baseMapper.queryPageExcel(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        if (BeanUtils.isNotEmpty(models)) {
            models.stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson(p);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //审核状态
                    if (map.get("status") != null) {
                        String status = map.get("status").toString();
                        String statusText = sysDictionaryDetailManager.getTextByValue("ggsd_sjshzt", status);
                        map.put("statusText", statusText);
                    } else {
                        map.put("statusText", "");
                    }
                    //时间期限
                    if (map.get("timePeriod") != null) {
                        String timePeriod = map.get("timePeriod").toString();
                        if (timePeriod.equals("0")){
                            map.put("timePeriodText","长期");
                        }else {
                            map.put("timePeriodText","限时");
                        }
                    } else {
                        map.put("timePeriodText", "");
                    }
                    //国家级主管部委
                    if (map.get("pilotSupervisor") != null) {
                        String pilotSupervisor = map.get("pilotSupervisor").toString();
                        String pilotSupervisorText = sysDictionaryDetailManager.getTextByValue("zgbw", pilotSupervisor);
                        map.put("pilotSupervisorText", pilotSupervisorText);
                    } else {
                        map.put("pilotSupervisorText", "");
                    }
                    //所属领域
                    if (map.get("pilotField") != null) {
                        String pilotField = map.get("pilotField").toString();
                        String pilotFieldText = sysDictionaryDetailManager.getTextByValue("ggbb_ssly", pilotField);
                        map.put("pilotFieldText", pilotFieldText);
                    } else {
                        map.put("pilotFieldText", "");
                    }
                    //审核状态
                    if (map.get("pilotRunway") != null) {
                        String pilotRunway = map.get("pilotRunway").toString();
                        String pilotRunwayText = sysDictionaryDetailManager.getTextByValue("ggbb_sspd", pilotRunway);
                        map.put("pilotRunwayText", pilotRunwayText);
                    } else {
                        map.put("pilotRunwayText", "");
                    }
                    //推进状态
                    if (map.get("propulsiveStatus") != null) {
                        String propulsiveStatus = map.get("propulsiveStatus").toString();
                        String propulsiveStatusText = sysDictionaryDetailManager.getTextByValue("sd_tjzt", propulsiveStatus);
                        map.put("propulsiveStatusText", propulsiveStatusText);
                    } else {
                        map.put("propulsiveStatusText", "");
                    }
                    //成果形式
                    if (map.get("resultForm") != null) {
                        String resultForm = map.get("resultForm").toString();
                        String resultFormText = sysDictionaryDetailManager.getTextByValue("cgxs", resultForm);
                        map.put("resultFormText", resultFormText);
                    } else {
                        map.put("resultFormText", "");
                    }
                    list.add(map);
                } catch (Exception e) {
                    throw new RuntimeException("导出失败：" + e.getMessage());
                }
            });
            String tempName = "改革试点市级项目";
            Map<String, String> exportMaps = new LinkedHashMap<>();
            exportMaps.put("pilotProjectName", "试点项目名称");
            exportMaps.put("docNo", "试点文件文号");
            exportMaps.put("documentBasis", "文件依据");
            exportMaps.put("pilotSupervisorText", "国家级主管部委");
            exportMaps.put("leadUnitName", "市级牵头部门");
            exportMaps.put("groupName", "专项小组");
            exportMaps.put("unitName", "责任单位");
            exportMaps.put("pilotFieldText", "所属领域");
            exportMaps.put("pilotRunwayText", "所属跑道");
            exportMaps.put("startTime", "开始时间");
            exportMaps.put("timePeriodText", "试点期限");
            exportMaps.put("acceptanceTime", "验收时间");
            exportMaps.put("pilotRange", "试点范围");
            exportMaps.put("pilotTarget", "试点目标");
            exportMaps.put("taskDetails", "任务详情");
            exportMaps.put("propulsiveStatusText", "推进状态");
            exportMaps.put("actualTime", "验收时间");
            exportMaps.put("propulsiveDetails", "已开展工作");
            exportMaps.put("existingProblems", "存在问题");
            exportMaps.put("workPlan", "下一步工作计划");
            exportMaps.put("resultName", "成果名称");
            exportMaps.put("resultFormText", "成果形式");
            exportMaps.put("resultDate", "成果形成日期");
            exportMaps.put("solveProblem", "具体举措及解决问题");
            exportMaps.put("actualEffect", "具体成效");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 14, exportMaps, list);
            ExcelUtil.downloadExcel(book, tempName, response);
        }
    }

    /**
     * 操作日志记录
     * @param record
     */
    @Transactional
    public void setApprovalLog(BizPilotAdvanceCityRecord record) {
        // 审批日志
        BizPilotAdvanceCityRecord r = bizPilotAdvanceCityRecordManager.getById(record.getId());
        BizReformPilotCityManagement entity = super.getOne(new QueryWrapper<BizReformPilotCityManagement>().eq("ID_", r.getPilotId()).eq("IS_DELE_", "0"),false);
        Assert.notNull(record,"推进信息不能为空");
        List<DictModel> ggsd_sjshzt = sysDictionaryManager.queryDictListItemsByCode("ggsd_sjshzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(record.getId());
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_REFORM_PILOT_CITY_MANAGEMENT");
        if (BeanUtils.isEmpty(record.getApprovalResults())||record.getApprovalResults()==0||record.getApprovalResults()==1){
            if (record.getStatus()% 2 == 0&&record.getStatus()!=0) {
                logVo.setApprovalResults(1);
            } else {
                logVo.setApprovalResults(0);
            }
            if (record.getStatus() == 0) {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】保存为草稿");
            } else if (record.getStatus() == 1) {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】提交待审核");
            } else if (record.getStatus() == 2) {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】审核驳回");
            } else if (record.getStatus() == 3) {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】审核通过");
            } else if (record.getStatus() == 4) {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】确认驳回");
            } else if (record.getStatus() == 5) {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】确认通过");
            }else if (record.getStatus() == 6){
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】核准驳回");
            }else {
                logVo.setItemTitle("【" + entity.getPilotProjectName() + "】核准通过");
            }
            logVo.setOperateInfo(BizUtils.getDicValueByCode(ggsd_sjshzt,record.getStatus()));
        }else if (record.getApprovalResults()==2){
            if (record.getStatus()==0){
                logVo.setItemTitle("【"+entity.getPilotProjectName()+"】撤回为草稿");
                logVo.setOperateInfo("撤回为草稿");
            }else if (record.getStatus()==1){
                logVo.setItemTitle("【"+entity.getPilotProjectName()+"】撤回为提交待审核");
                logVo.setOperateInfo("撤回为提交待审核");
            }else if (record.getStatus()==3){
                logVo.setItemTitle("【"+entity.getPilotProjectName()+"】撤回为审核通过");
                logVo.setOperateInfo("撤回为审核通过");
            }else if (record.getStatus()==5){
                logVo.setItemTitle("【"+entity.getPilotProjectName()+"】撤回为确认通过");
                logVo.setOperateInfo("撤回为确认通过");
            }
            logVo.setApprovalResults(2);
        }
        logVo.setStatus(record.getStatus().toString());
        logVo.setApprovalComments(record.getApprovalComments());
        logVo.setBizType("5");
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        if (BeanUtils.isNotEmpty(logVo)) {
            // 保存审批日志
            achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
        }
    }


}
