package com.artfess.reform.fill.manager.impl;

import cn.hutool.db.Db;
import com.artfess.base.exception.BaseException;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.BizMeetingCooperativeUnitManager;
import com.artfess.reform.fill.manager.BizMeetingDocumentsPushManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizMeetingCooperativeUnit;
import com.artfess.reform.fill.model.BizMeetingDocumentsConsidered;
import com.artfess.reform.fill.dao.BizMeetingDocumentsConsideredDao;
import com.artfess.reform.fill.manager.BizMeetingDocumentsConsideredManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.model.BizMeetingDocumentsPush;
import com.artfess.reform.fill.model.BizMeetingEventDetails;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.xlsx4j.sml.Row;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 会议审议通过文件管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@Service
public class BizMeetingDocumentsConsideredManagerImpl extends BaseManagerImpl<BizMeetingDocumentsConsideredDao, BizMeetingDocumentsConsidered> implements BizMeetingDocumentsConsideredManager {

@Resource
private BizMeetingDocumentsPushManager bizMeetingDocumentsPushManager;
@Resource
private AchieveStatusLogManager achieveStatusLogManager;
@Resource
private BizMeetingCooperativeUnitManager bizMeetingCooperativeUnitManager;
@Resource
private FileManager fileManager;
@Resource
private SysDictionaryDetailManager sysDictionaryDetailManager;

    @Override
    public PageList<BizMeetingDocumentsConsidered> queryPush(QueryFilter<BizMeetingDocumentsConsidered> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        if (!ContextUtil.getCurrentUser().isAdmin()){
            queryFilter.addFilter("CREATE_ORG_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("SEND_STATUS_",Direction.ASC));
        sorter.add(new FieldSort("LAST_TIME_",Direction.DESC));
        queryFilter.setSorter(sorter);
        PageList<BizMeetingDocumentsConsidered> query = this.query(queryFilter);
        return query;
    }

    @Override
    public PageList<BizMeetingDocumentsConsidered> queryAudit(QueryFilter<BizMeetingDocumentsConsidered> queryFilter, boolean isAffirm) {
        queryFilter.addFilter("c.IS_DELE_","0", QueryOP.EQUAL);
        if (!ContextUtil.getCurrentUser().isAdmin()&&!isAffirm){
            queryFilter.addFilter("u.UNIT_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        }
        IPage<BizMeetingDocumentsConsidered> page = baseMapper.queryAudit(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(page);
    }

    @Override
    @Transactional
    public Boolean removeById(String ids) {
        Assert.notNull("ids","需要删除的id不能为空");
        String[] split = ids.split(",");
        for (String id : split) {
            BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered = baseMapper.selectOne(new QueryWrapper<BizMeetingDocumentsConsidered>().eq("ID_", id).eq("IS_DELE_", "0"));
            if (bizMeetingDocumentsConsidered.getSendStatus()==1){
                throw new BaseException("已分发的数据无法删除！");
            }
            bizMeetingDocumentsPushManager.remove(new QueryWrapper<BizMeetingDocumentsPush>().eq("MEETING_ID_", id).eq("IS_DELE_", "0"));
            return super.removeById(id);
        }

        return false;
    }

    @Override
    @Transactional
    public Boolean insertInfo(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered) {
        Assert.notNull(bizMeetingDocumentsConsidered,"对象不能为空");
        Assert.notNull(bizMeetingDocumentsConsidered.getInvs(),"涉及责任单位不能为空");
        boolean save = super.save(bizMeetingDocumentsConsidered);
        //添加责任单位
        List<BizMeetingCooperativeUnit> invs = bizMeetingDocumentsConsidered.getInvs();
        invs.stream().forEach(p->{
            p.setMaiinType(1);
            p.setMeetingId(bizMeetingDocumentsConsidered.getId());
            p.setMaiinType(bizMeetingDocumentsConsidered.getMeetingType());
        });
        bizMeetingCooperativeUnitManager.saveBatch(invs);
        return save;
    }

    @Override
    @Transactional
    public void updateInfo(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered) {
       Assert.notNull(bizMeetingDocumentsConsidered,"bizMeetingDocumentsConsidered不能为空");
       super.update(bizMeetingDocumentsConsidered);
       if (null !=bizMeetingDocumentsConsidered.getInvs()&&bizMeetingDocumentsConsidered.getInvs().size()>0){
           //删除不在责任单位部门中的id
           bizMeetingCooperativeUnitManager.remove(new QueryWrapper<BizMeetingCooperativeUnit>().eq("MEETING_ID_",bizMeetingDocumentsConsidered.getId()));
           //新增或者修改推进对象
           List<BizMeetingCooperativeUnit> invs = bizMeetingDocumentsConsidered.getInvs();
           invs.stream().forEach(p-> {
               p.setMaiinType(1);
               p.setMeetingId(bizMeetingDocumentsConsidered.getId());
               p.setMaiinType(bizMeetingDocumentsConsidered.getMeetingType());
           });
           bizMeetingCooperativeUnitManager.saveOrUpdateBatch(invs);
       }
    }

    @Override
    @Transactional
    public void updateByStatus(BizMeetingDocumentsConsidered bizMeetingDocumentsConsidered) {
        Assert.notNull(bizMeetingDocumentsConsidered.getId(),"需要修改的id不能为空");
        //删除分发未录入的区县
//        BizMeetingDocumentsConsidered entity = super.getById(bizMeetingDocumentsConsidered.getId());
//        if (entity.getSendStatus()==1&&bizMeetingDocumentsConsidered.getSendStatus()==0){
//            bizMeetingCooperativeUnitManager.remove(new QueryWrapper<BizMeetingCooperativeUnit>()
//                    .eq("MEETING_ID_",bizMeetingDocumentsConsidered.getId()));
//        }
        super.update(new UpdateWrapper<BizMeetingDocumentsConsidered>().eq("ID_",bizMeetingDocumentsConsidered.getId()).eq("IS_DELE_","0").set("SEND_STATUS_",bizMeetingDocumentsConsidered.getSendStatus()));
    }

    @Override
    public List<BizMeetingDocumentsPush> findByHis(String id,String unitId) {
        Assert.notNull(id,"id不能为空");
        Assert.notNull(unitId,"涉及责任单位组织机构id不能为空");
        //添加当前数据和历史第一条数据
        List<BizMeetingDocumentsPush> entity = bizMeetingDocumentsPushManager.list(new QueryWrapper<BizMeetingDocumentsPush>()
                .eq("MEETING_ID_", id)
                .eq("UNIT_ID_",unitId)
                .eq("IS_DELE_", "0")
                .orderByDesc("CREATE_TIME_")
                .last("LIMIT 2"));
        entity.stream().forEach(p-> {
            //从操作日志记录表中获取提交驳回意见
            if (BeanUtils.isNotEmpty(p)) {
                AchieveStatusLog log = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                        .eq("BIZ_ID_", p.getId())
                        .orderByDesc("OPERATE_DATE_")
                        .last("LIMIT 1"));
                if (BeanUtils.isNotEmpty(log)) {
                    p.setApprovalComments(log.getApprovalComments());
                }
            }
            //查询附件
            List<DefaultFile> files = fileManager.list(new QueryWrapper<DefaultFile>().eq("BIZ_ID_", p.getId()).eq("IS_DEL_", "0"));
            if (null!=files&&files.size()>0){
                p.setFiles(files);
            }

        });

        return entity;
    }

    @Override
    public BizMeetingDocumentsConsidered findByModel(String id) {
        Assert.notNull(id,"id不能为空");
        BizMeetingDocumentsConsidered entity = baseMapper.selectOne(new QueryWrapper<BizMeetingDocumentsConsidered>().eq("ID_", id).eq("IS_DELE_", "0").last("LIMIT 1"));
        List<BizMeetingCooperativeUnit> list = bizMeetingCooperativeUnitManager.list(new QueryWrapper<BizMeetingCooperativeUnit>().eq("MEETING_ID_", entity.getId()));
        if (null!=list&&list.size()>0){
            entity.setInvs(list);
        }
        return entity;
    }

    @Override
    public void exportExcel(HttpServletResponse response, QueryFilter<BizMeetingDocumentsConsidered> queryFilter) throws Exception {
        List<Map<String, Object>> list = new ArrayList<>();
        queryFilter.addFilter("c.IS_DELE_","0",QueryOP.EQUAL);
        queryFilter.addFilter("c.SEND_STATUS_",1,QueryOP.EQUAL);
        IPage<BizMeetingDocumentsConsidered> iPage = baseMapper.exportExcel(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        PageList<BizMeetingDocumentsConsidered> pageList = new PageList<>(iPage);
        if (BeanUtils.isNotEmpty(pageList.getRows())) {
            pageList.getRows().stream().forEach(p -> {
                try {
                    String jsonStr = JsonUtil.toJson(p);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    //推进状态
                    if (map.get("abutmentStatus") != null) {
                        String abutmentStatus = map.get("abutmentStatus").toString();
                        String abutmentStatusText = sysDictionaryDetailManager.getTextByValue("tjzt", abutmentStatus);
                        map.put("abutmentStatusText", abutmentStatusText);
                    } else {
                        map.put("abutmentStatusText", "");
                    }
                     //对接方式
                    if (map.get("abutmentType") != null) {
                        String abutmentType = map.get("abutmentType").toString();
                        String abutmentTypeText = sysDictionaryDetailManager.getTextByValue("djfs", abutmentType);
                        map.put("abutmentTypeText",abutmentTypeText);
                    }else {
                        map.put("abutmentTypeText", "");
                    }

                    //会议类型
                    if (map.get("meetingType") != null) {
                        String meetingType = map.get("meetingType").toString();
                        String meetingTypeText = sysDictionaryDetailManager.getTextByValue("wjglhylx", meetingType);
                        map.put("meetingTypeText",meetingTypeText);
                    }else {
                        map.put("meetingTypeText", "");
                    }
                    list.add(map);
                } catch (Exception e) {
                    throw new RuntimeException("导出失败：" + e.getMessage());
                }
            });
            String tempName = "需对接文件";
            Map<String, String> exportMaps = new LinkedHashMap<>();
            exportMaps.put("fileName", "文件名称");
            exportMaps.put("meetingTypeText", "会议类型");
            exportMaps.put("meetingName", "会议名称");
            exportMaps.put("reviewTime", "审议时间");
            exportMaps.put("feedbackTimeLimit", "反馈时限");
            exportMaps.put("unitName", "对接责任单位");
            exportMaps.put("abutmentStatusText","推进状态");
            exportMaps.put("abutmentTypeText", "对接方式");
            exportMaps.put("abutmentDetailed", "对接详情");
            HSSFWorkbook book = ExcelUtil.exportExcel(tempName, 24, exportMaps, list);
            ExcelUtil.downloadExcel(book, tempName, response);
        }
    }

}
