package com.artfess.reform.fill.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizDigitalConstruction;
import com.artfess.base.manager.BaseManager;

import java.time.LocalDateTime;


/**
 * 推动数字重庆建设 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
public interface BizDigitalConstructionManager extends BaseManager<BizDigitalConstruction> {
    /**
     *区县填报及审核查询
     */
    PageList<BizDigitalConstruction> queryByPage(QueryFilter<BizDigitalConstruction> queryFilter);

    /**
     * 区县填报查询
     * @param id
     * @return
     */
    BizDigitalConstruction getByCreate(String id);

    BizDigitalConstruction getByAudit(String id);

    /**
     * 区县审核及改革办审核查询
     * @param id
     * @return
     */
    BizDigitalConstruction getExamineById(String id);

    /**
     * 查询历史记录
     * @param id
     * @return
     */
    BizDigitalConstruction getHisById(String unitId, LocalDateTime date,boolean isAffirm);

     boolean updateByStatus(BizDigitalConstruction bizDigitalConstruction);

     boolean invIsNew(String id,String unitId);
}
