package com.artfess.reform.approvalLog.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */

@Data
@ApiModel(value="BizAchieveStatusLog对象", description="操作状态日志跟踪记录")
@TableName("BIZ_ACHIEVE_STATUS_LOG")
public class AchieveStatusLog extends AutoFillFullModel<AchieveStatusLog> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "业务数据类型（1：改革需求业务，2：改革需求交办业务，3：堵点卡点业务，4：成效晾晒比拼，5：改革试点管理，6-1：市级重大改革项目量化目标推进，6-2：市级重大项目计划推进6-3：市级重大改革项目经验推广 6-4：市级重大改革项目成果晾晒，7：改革满意度管理，8：改革风险管理，9：深改委会议管理 10:谋划储备一批和准备启动一批 ）")
    @TableField("BIZ_TYPE")
    private String bizType;

    @ApiModelProperty(value = "业务数据模型表_ID（数据表ID）")
    @TableField("MODULE_ID_")
    private String moduleId;

    @ApiModelProperty(value = "业务数据模型表_表名（数据表表名）")
    @TableField("MODULE_TABLE_NAME_")
    private String moduleTableName;

    @ApiModelProperty(value = "业务数据_ID（关联业务数据ID）")
    @TableField("BIZ_ID_")
    private String bizId;

    @ApiModelProperty(value = "工作项标题【需要组合任务生成标题名称】")
    @TableField("ITEM_TITLE_")
    private String itemTitle;

    @ApiModelProperty(value = "动作步骤状态（与审批状态保持一致）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "操作详情说明（与流程审批状态值描述保持一致）")
    @TableField("OPERATE_INFO_")
    private String operateInfo;

    @ApiModelProperty(value = "操作顺序号（当前最大值+1）")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "执行结果（0：同意，1：驳回）")
    @TableField("APPROVAL_RESULTS_")
    private Integer approvalResults;

    @ApiModelProperty(value = "审批意见描述")
    @TableField("APPROVAL_COMMENTS_")
    private String approvalComments;

    @ApiModelProperty(value = "操作机构_ID")
    @TableField("OPERATE_ORG_ID_")
    private String operateOrgId;

    @ApiModelProperty(value = "操作机构_NAME")
    @TableField("OPERATE_ORG_NAME_")
    private String operateOrgName;

    @ApiModelProperty(value = "操作部门_ID")
    @TableField("OPERATE_DEPT_ID_")
    private String operateDeptId;

    @ApiModelProperty(value = "操作部门_NAME")
    @TableField("OPERATE_DEPT_NAME_")
    private String operateDeptName;

    @ApiModelProperty(value = "操作人员_ID")
    @TableField("OPERATE_USER_ID_")
    private String operateUserId;

    @ApiModelProperty(value = "操作人员_NAME")
    @TableField("OPERATE_USER_NAME_")
    private String operateUserName;

    @ApiModelProperty(value = "操作人员_ACCOUNT")
    @TableField("OPERATE_USER_ACCOUNT_")
    private String operateUserAccount;

    @ApiModelProperty(value = "操作时间")
    @TableField("OPERATE_DATE_")
    private LocalDateTime operateDate;



}
