package com.artfess.reform.statistics.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.fill.dao.BizReformDemandAnalysisLibraryDao;
import com.artfess.reform.fill.dao.BizReformPilotManagementDao;
import com.artfess.reform.fill.manager.BizReformDemandAnalysisLibraryManager;
import com.artfess.reform.fill.manager.BizReformDemandAssignmentManager;
import com.artfess.reform.fill.model.BizReformDemandAnalysisLibrary;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.reform.fill.vo.DemandAnalysisLibraryNumVo;
import com.artfess.reform.fill.vo.DemandAssignmentVo;
import com.artfess.reform.fill.vo.IterationAddVO;
import com.artfess.reform.fill.vo.IterationUpdateVO;
import com.artfess.reform.majorProjects.dao.*;
import com.artfess.reform.majorProjects.manager.PilotMeasuresPushManager;
import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedule;
import com.artfess.reform.majorProjects.vo.QuantitativeObjectivesVo;
import com.artfess.reform.statistics.dao.BizScoringProjectBrandDao;
import com.artfess.reform.statistics.dao.BizScoringProjectIterationDao;
import com.artfess.reform.statistics.dao.BizScoringProjectMeasureDao;
import com.artfess.reform.statistics.dao.BizScoringProjectSynDao;
import com.artfess.reform.statistics.dao.BizScoringProjectTargetDao;
import com.artfess.reform.statistics.manager.ProjectLargeScreeManager;
import com.artfess.reform.statistics.model.BizScoringProjectBrand;
import com.artfess.reform.statistics.model.BizScoringProjectIteration;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;
import com.artfess.reform.statistics.vo.*;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * @author 黎沐华
 * @date 2023/3/31 2Project
 */
@Service
public class ProjectLargeScreeManagerImpl implements ProjectLargeScreeManager {

    @Resource
    private BizScoringProjectSynDao synDao;
    @Resource
    private BizScoringProjectBrandDao brandDao;
    @Resource
    private BizScoringProjectMeasureDao measureDao;
    @Resource
    private BizScoringProjectTargetDao targetDao;
    @Resource
    private PilotSpecificScheduleDao scheduleDao;
    @Resource
    private PilotMeasuresPushManager pilotMeasuresPushManager;
    @Resource
    private BizScoringProjectIterationDao iterationDao;
    @Resource
    private BizReformDemandAnalysisLibraryManager demandManager;
    @Resource
    private BizReformDemandAnalysisLibraryDao demandAnalysisLibraryDao;
    @Resource
    private BizReformDemandAssignmentManager demandRecordMaanger;
    @Resource
    private SysDictionaryManager sdm;
    @Resource
    private PilotSpecificMeasuresDao pilotSpecificMeasuresDao;
    @Resource
    private PilotQuantitativeObjectivesPushDao pilotQuantitativeObjectivesPushDao;
    @Resource
    private PilotSpecificScheduleDao pilotSpecificScheduleDao;
    @Resource
    private PilotExperiencePushDao pilotExperiencePushDao;
    @Resource
    private PilotBrandPushDao pilotBrandPushDao;
    @Resource
    private BizReformPilotManagementDao bizReformPilotManagementDao;

    @Override
    public JSONArray indexRank(String type,Integer year,Integer month) {
        Assert.notNull(type, "类型不能为空！");
        JSONArray data = new JSONArray();
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        switch (type) {
            case "composite":
                List<BizScoringProjectSyn> synList = synDao.queryLatest(year, month, null, null);
                List<BizScoringProjectSyn> lastQData =  synDao.queryLatest(year, month-1, "M", null);
                synList.forEach(syn -> {
                    lastQData.forEach(ld -> {
                        if (syn.getProjectId().equals(ld.getProjectId())) {
                            syn.setTrend(ld.getAllSn()-syn.getAllSn());
                        }
                    });
                });
                data.addAll(synList);
                break;
            case "single":
                List<BizScoringProjectBrand> brandList = brandDao.queryLatestNo1(year, month, null);
                brandList = brandList == null ? Lists.newArrayList() : brandList;
                for(BizScoringProjectBrand brand:brandList){
                    CountyIndexVo wVo = new CountyIndexVo("品牌显示度");
                    wVo.setCounty(brand.getProjectName());
                    wVo.setHoldNum(String.valueOf(brand.getHoldNum()));
                    data.add(wVo);
                }

                List<BizScoringProjectMeasure> measureList = measureDao.queryLatestNo1(year, month, null);
                measureList = measureList == null ? Lists.newArrayList() : measureList;
                for(BizScoringProjectMeasure measure:measureList){
                    CountyIndexVo wVo = new CountyIndexVo("具体措施推进力");
                    wVo.setCounty(measure.getProjectName());
                    wVo.setHoldNum(String.valueOf(measure.getHoldNum()));
                    data.add(wVo);
                }

                List<BizScoringProjectTarget> targetList = targetDao.queryLatestNo1(year, month, null);
                targetList = targetList == null ? Lists.newArrayList() : targetList;
                for(BizScoringProjectTarget target:targetList){
                    CountyIndexVo wVo = new CountyIndexVo("量化目标推进力");
                    wVo.setCounty(target.getProjectName());
                    wVo.setHoldNum(String.valueOf(target.getHoldNum()));
                    data.add(wVo);
                }
                break;
            default:
                throw new RuntimeException("type传递错误，允许值：composite 综合排名,single 单项");
        }
        return data;
    }

    @Override
    public JSONObject monthPlanNum(String projectId,Integer year, Integer month) {
        JSONObject result = new JSONObject();
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        MonthPlanNumVO monthPlanNumVO = scheduleDao.queryMonthPlanNum(year,month,projectId);
        if(monthPlanNumVO.getTotalNum() == 0){
            monthPlanNumVO.setFinishRate(new BigDecimal(0));
        }else{
            BigDecimal finishRate = new BigDecimal(monthPlanNumVO.getFinishNum()).divide(new BigDecimal(monthPlanNumVO.getTotalNum()),4,BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
            monthPlanNumVO.setFinishRate(finishRate);
        }

        List<MonthPlanNumVO> list = scheduleDao.queryMonthPlanNumAll(year,month,projectId);

        Map<String,Long> map = list.stream().collect(Collectors.groupingBy(MonthPlanNumVO::getDegree, Collectors.counting()));

        result.put("total",monthPlanNumVO);
        result.put("degree",map);
        return result;
    }

    @Override
    public List<MonthPlanNumVO> monthPlanNumForProject(Integer year, Integer month) {
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<MonthPlanNumVO> list = scheduleDao.queryMonthPlanNumAll(year,month,null);
        return list;
    }

    @Override
    public JSONObject  monthPlanNumDetails(Integer year, Integer month, String projectId) {
        JSONObject result = new JSONObject();
//        if (year == null || year == 0) {
//            year = LocalDate.now().getYear();
//        }
//        if (month == null || month == 0) {
//            month = LocalDate.now().getMonthValue();
//        }
        //按照查询推进进度统计
        MonthPlanNumVO monthPlanNumVO = scheduleDao.queryMonthPlanNum(year,month,projectId);
        //按照查询月度计划类型统计
        List<MonthPlanTypeNumVO> typeNum = scheduleDao.queryMonthPlanNumForType(year,month,projectId);

        result.put("total",monthPlanNumVO);
        result.put("typeNum",typeNum);

        return result;
    }

    @Override
    public JSONObject targetNum(Integer year, Integer month) {
        JSONObject result = new JSONObject();
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }

        return null;
    }


    @Override
    public JSONObject demandHeatList(Integer year,Integer month) {
        JSONObject result = new JSONObject();
        // 获取当前年,季度
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }

        List<CountyChartVo> chartData = demandManager.chartDataForLargeScreen(year,month);
        result.put("chart", chartData);

        // 取出根数据并合并
        List<DemandAnalysisLibraryNumVo> demandData = demandAnalysisLibraryDao.countNum(year,month,null);

        QueryWrapper<BizReformDemandAssignment> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("year(MEETING_DATE_)", year).le("month(MEETING_DATE_)", month);
        int count = demandRecordMaanger.count(queryWrapper);
        if(count>0){
            for(DemandAnalysisLibraryNumVo numVo:demandData){
                BigDecimal f = new BigDecimal(numVo.getListNum()).divide(new BigDecimal(count),2,BigDecimal.ROUND_HALF_UP);
                BigDecimal qualityRate = new BigDecimal(numVo.getProjectNum()).add(f);
                numVo.setQualityRate(qualityRate);
            }
        }
        result.put("demandRank", demandData);

        return result;
    }

    @Override
    public JSONObject demandDetailList(QueryFilter<BizReformDemandAssignment> queryFilter) {
        JSONObject result = new JSONObject();
        List<QueryField> querys = queryFilter.getQuerys();
        Object flagYear = null;
        Object flagMonth = null;
        if (querys != null && querys.size() > 0) {
            for (QueryField field : querys) {
                if (field.getProperty().trim().toLowerCase().equals("a.propulsive_year_") || field.getProperty().trim().toLowerCase().equals("a.propulsiveyear")) {
                    flagYear = field.getValue();
                    continue;
                }
                if (field.getProperty().trim().toLowerCase().equals("a.propulsive_month_") || field.getProperty().trim().toLowerCase().equals("a.propulsivemonth")) {
                    flagMonth = field.getValue();
                    continue;
                }

            }
        }
        if (flagYear == null) {
            flagYear = LocalDate.now().getYear();;
            queryFilter.addFilter("a.PROPULSIVE_YEAR_", flagYear, QueryOP.EQUAL);

        }
        if(flagMonth == null){
            flagMonth =LocalDate.now().getMonthValue();
            queryFilter.addFilter("a.PROPULSIVE_MONTH_", flagMonth, QueryOP.LESS_EQUAL);
        }
        // 所有统计数据
        List<BizReformDemandAnalysisLibrary> demandData = demandManager.list(new QueryWrapper<BizReformDemandAnalysisLibrary>().eq("DEMAND_YEAR_", flagYear).le("DEMAND_MONTH_", flagMonth).eq("STATUS_", 5));
        // 领域分类
        List<DictModel> ssly = sdm.queryDictListItemsByCode("ggbb_ssly");
        Map<Integer, List<BizReformDemandAnalysisLibrary>> domainGroupDeman = demandData.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandField));
        List<CountyChartVo> domainChart = Lists.newArrayList();
        domainGroupDeman.entrySet().forEach(en -> domainChart.add(new CountyChartVo(BizUtils.getDicValueByCode(ssly, en.getKey()), en.getValue().size())));
        result.put("domainChart", domainChart);
        // 过程管理
        List<DictModel> cyzt = sdm.queryDictListItemsByCode("ggbb_cyzt");
        Map<Integer, List<BizReformDemandAnalysisLibrary>> processGroupDeman = demandData.stream().collect(Collectors.groupingBy(BizReformDemandAnalysisLibrary::getDemandAdoptionStatus));
        List<CountyChartVo> processChart = Lists.newArrayList();
        processGroupDeman.entrySet().forEach(en -> processChart.add(new CountyChartVo(BizUtils.getDicValueByCode(cyzt, en.getKey()), en.getValue().size())));

        Map<Integer, List<BizReformDemandAssignment>> processStatuasGroup = demandRecordMaanger.list(new QueryWrapper<BizReformDemandAssignment>().eq("PROPULSIVE_YEAR_", flagYear).le("PROPULSIVE_MONTH_",
                flagMonth).isNotNull("DEMAND_STATUS_")).stream().collect(Collectors.groupingBy(BizReformDemandAssignment::getDemandStatus));
        AtomicInteger pushNum = new AtomicInteger();
        processStatuasGroup.entrySet().forEach(psg -> {
            if (psg.getKey() == 1) {
                pushNum.set(pushNum.get() + psg.getValue().size());
            }
            if (psg.getKey() == 2) {
                pushNum.set(pushNum.get() + psg.getValue().size());
            }
            if (psg.getKey() == 3) {
                processChart.add(new CountyChartVo("完成销号", psg.getValue().size()));
            }
        });
        processChart.add(new CountyChartVo("交办区县落实", pushNum.get()));
        result.put("processChart", processChart);

        // 清单数据
        queryFilter.addFilter("a.is_dele_", "0", QueryOP.EQUAL);
        PageList<DemandAssignmentVo> recordList = demandRecordMaanger.queryDemandAssignment(queryFilter);
        result.put("recordList", recordList);

        return result;
    }

    @Override
    public List<BrandLineChartVO> brandLineChart(String projectId,Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<BrandLineChartVO> list = brandDao.brandLineChart(projectId,year,month);
        // 补充没有数据的月份，按月份升序排序
        boolean existsTwelveMonths = IntStream.rangeClosed(1, 12).allMatch(monthl -> list.stream().anyMatch(vo -> vo.getFillMonth() == monthl));
        if (!existsTwelveMonths) {
            Integer finalYear = year;
            IntStream.rangeClosed(1, 12).filter(monthl -> list.stream().noneMatch(vo -> vo.getFillMonth() == monthl))
                    .mapToObj(monthl -> new BrandLineChartVO(finalYear,monthl, 0,0,0)) // 创建新的VO对象
                    .forEach(list::add); // 将新的VO对象添加到List中
        }
        list.sort(Comparator.comparingInt(BrandLineChartVO::getFillMonth));

        return list;
    }

    @Override
    public List<BrandLineChartVO> queryBrandForProject(String projectId,Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<BrandLineChartVO> list = brandDao.queryBrandForProject(projectId,year,month);

        return list;
    }

    @Override
    public List<PilotBrandPush> queryBrandForProjectInfo(String projectId, Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        return pilotBrandPushDao.queryBrandForProjectInfo(projectId,year,month);
    }

    @Override
    public List<BizScoringProjectIteration> queryIterationForProject(Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
        List<BizScoringProjectIteration> list = iterationDao.queryIterationByDate(year,null,month);
        return list;
    }

    @Override
    public IterationVo queryIterationForProjectInfo(String projectId,Integer year,Integer month) {
        List<IterationAddVO> addVOS = pilotSpecificMeasuresDao.iterationAdd(projectId,year,month);
        List<IterationUpdateVO> updateVOS = pilotSpecificMeasuresDao.iterationUpdate(projectId,year,month);
        IterationVo iIterationVo=new IterationVo();
        iIterationVo.setIterationAddVO(addVOS);
        iIterationVo.setIterationUpdateVO(updateVOS);
        return iIterationVo;
    }

    @Override
    public ScheduleVo achievementCount(String projectId,Integer year, Integer month) {
        ScheduleVo scheduleVo=new ScheduleVo();
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }
//        //搭建重要平台数量统计
//        Integer platformCount = scheduleDao.achievementCount(projectId,year,month,6);
//        scheduleVo.setPlatformCount(platformCount);
//        //搭建重要平台环比统计
//        Integer oldPlatformCount = scheduleDao.achievementCount(projectId,year,month-1,6);
//        int platformChain = platformCount - oldPlatformCount;
//        scheduleVo.setPlatformChain(platformChain);
        //形成制度成果数量统计
        Integer achievementCount = scheduleDao.achievementCount(projectId,year,month,5);
        scheduleVo.setAchievementCount(achievementCount);
        //形成制度成果环比统计
        Integer oldAchievementCount = scheduleDao.achievementCount(projectId,year,month-1,5);
        int achievementChain = achievementCount - oldAchievementCount;
        scheduleVo.setAchievementChain(achievementChain);
//        //上线应用场景数量统计
//        Integer scenarioCount = scheduleDao.achievementCount(projectId,year,month,7);
//        scheduleVo.setScenarioCount(scenarioCount);
//        //上线应用场景环比统计
//        Integer oldScenarioCount = scheduleDao.achievementCount(projectId,year,month-1,7);
//        int scenarioChain = scenarioCount - oldScenarioCount;
//        scheduleVo.setScenarioChain(scenarioChain);
        return scheduleVo;
    }

    @Override
    public List<ScheduleVo> achievementInvCount(Integer year, Integer month) {
        if (year == null || year == 0) {
            year = LocalDate.now().getYear();
        }
        if (month == null || month == 0) {
            month = LocalDate.now().getMonthValue();
        }

        return scheduleDao.achievementInvCount(year,month);
    }

    @Override
    public PageList<PilotMeasuresPush> achievementInfo(QueryFilter<PilotMeasuresPush> queryFilter) {
       return pilotMeasuresPushManager.achievementInfo(queryFilter);
    }

    @Override
    public IndexVo reachRateCount(String projectId, Integer year, Integer month) {
        if (year==null||year<0){
            year=LocalDate.now().getYear();
        }
        if (month==null||month<1||month>12){
            month=LocalDate.now().getMonthValue();
        }
        return pilotQuantitativeObjectivesPushDao.reachRateCount(projectId,year, month);
    }

    @Override
    public IndexProjectVo reachProjectRateCount(Integer year, Integer month) {
        if (year==null||year<0){
            year=LocalDate.now().getYear();
        }
        if (month==null||month<1||month>12) {
            month = LocalDate.now().getMonthValue();
        }
        List<IndexVo> indexVo = pilotQuantitativeObjectivesPushDao.reachProjectRateCount(null, year, month);
//        //将所有数据进行去重
//        List<Integer> noList = indexVo.stream().distinct().map(IndexVo::getNo).collect(Collectors.toList());
//        //求总数据的百分之20%的个数
//        double excellentRate = noList.size() * 0.2;
//        //求总数据的百分之30%的个数
//        double qualifiedRate = noList.size() * 0.3;
//        long excellentNum=0;
//        long qualifiedNum=0;
//        if (Math.round(excellentRate)==0){
//            excellentNum=1;
//        }else {
//            excellentNum=Math.round(excellentRate);
//        }
//
//        if (Math.round(qualifiedRate)==0){
//            qualifiedNum=1;
//        }else {
//            qualifiedNum = Math.round(qualifiedRate);
//        }
//        Integer excessCount=0;
//        Integer reachedCount=0;
//        if(noList!=null&&noList.size()>=1) {
//            //求百分之二十里排序号最大的值
//            Integer excellentNo = noList.get((int) excellentNum - 1);
//            //求大于百分之二十里排序号取百分之30%的个数
//            List<Integer> qualifiedNo=new ArrayList<>();
//            if(noList.size()>1){
//                qualifiedNo = noList.subList((int) excellentNum, (int) excellentNum + (int) qualifiedNum);
//            }
//
//                for (OverViewComplianceStatusInfoVo overViewComplianceStatusInfoVo : overViewComplianceStatusInfoVoList) {
//                    if (overViewComplianceStatusInfoVo.getNo()<=excellentNo){
//                        overViewComplianceStatusInfoVo.setGrade(1);
//                        excessCount++;
//                    }else if (qualifiedNo.contains(overViewComplianceStatusInfoVo.getNo())){
//                        overViewComplianceStatusInfoVo.setGrade(2);
//                        reachedCount++;
//                    }else {
//                        overViewComplianceStatusInfoVo.setGrade(3);
//                    }
//                }
//
//        }
//        OverViewComplianceStatusVo overViewComplianceStatusVo=new OverViewComplianceStatusVo();
//        //统计个数
//        OverViewComplianceStatusCountVo overViewComplianceStatusCountVo=new OverViewComplianceStatusCountVo();
//        overViewComplianceStatusCountVo.setExcessCount(excessCount);
//        overViewComplianceStatusCountVo.setReachedCount(reachedCount);
//        overViewComplianceStatusCountVo.setNotReachedCount(overViewComplianceStatusInfoVoList.size()-excessCount-reachedCount);
//        overViewComplianceStatusVo.setOverViewComplianceStatusCountVo(overViewComplianceStatusCountVo);
//        overViewComplianceStatusVo.setOverViewComplianceStatusInfoVoList(overViewComplianceStatusInfoVoList);

        long count = indexVo.stream().filter(p -> p.getComplianceRate().compareTo(new BigDecimal(100)) == 0).count();
        IndexCountVo indexCountVo=new IndexCountVo();
        indexCountVo.setReachedCount(count);
        indexCountVo.setNotReachedCount(indexVo.size()-count);
        IndexProjectVo indexProjectVo=new IndexProjectVo();
        indexProjectVo.setIndexVoList(indexVo);
        indexProjectVo.setIndexCountVo(indexCountVo);
        return indexProjectVo;
    }

    @Override
    public IndexDetailsVo indexDetails(String projectId, Integer year, Integer month) {
        if (year==null||year<0){
            year=LocalDate.now().getYear();
        }
        if (month==null||month<1||month>12){
            month=LocalDate.now().getMonthValue();
        }
        List<IndexDetailsInfoVo> indexDetailsInfoVos = pilotQuantitativeObjectivesPushDao.indexDetailsInfo(projectId, year, month);
        List<IndexCountVo> countVos = pilotQuantitativeObjectivesPushDao.indexDetailsCount(projectId, year, month);
        IndexDetailsVo indexDetailsVo=new IndexDetailsVo();
        indexDetailsVo.setIndexDetailsInfoVoList(indexDetailsInfoVos);
        indexDetailsVo.setIndexCountVo(countVos);
//        IndexProjectVo overviewComplianceVo=new IndexProjectVo();
//        overviewComplianceVo.indexCountDetails(overViewComplianceCountVo);
//        overviewComplianceVo.setOverviewComplianceInfoVoList(complianceInfoVos);
        return indexDetailsVo;
    }

    @Override
    public List<PilotSpecificSchedule> schedulePlanInfo(String projectId, Integer year, Integer month) {
        if (year==null||year<0){
            year=LocalDate.now().getYear();
        }
        if (month==null||month<1||month>12){
            month=LocalDate.now().getMonthValue();
        }
       return pilotSpecificScheduleDao.schedulePlanInfo(projectId,year,month);
    }

    @Override
    public List<PilotExperiencePush> pilotExperiencePushInfo(String projectId, Integer year, Integer month) {
        if (year==null||year<0){
            year=LocalDate.now().getYear();
        }
        if (month==null||month<1||month>12){
            month=LocalDate.now().getMonthValue();
        }
        return pilotExperiencePushDao.pilotExperiencePushInfo(projectId,year,month);
    }

    @Override
    public List<QuantitativeObjectivesVo> quantitativeObjectivesInfo(String projectId,Integer year, Integer month) {
        if (year==null||year<0){
            year=LocalDate.now().getYear();
        }
        if (month==null||month<1||month>12){
            month=LocalDate.now().getMonthValue();
        }
        List<QuantitativeObjectivesVo> quantitativeObjectivesVos = pilotQuantitativeObjectivesPushDao.quantitativeObjectivesInfo(projectId, year, month);
        return quantitativeObjectivesVos;
    }

    @Override
    public AcceptanceVo acceptanceRateInfo(LocalDate countDate, String unitId) {
        if (countDate==null) countDate=LocalDate.now();
        //应验收信息
        List<BizReformPilotManagement> shouldAcceptance = bizReformPilotManagementDao.shouldAcceptance(countDate, unitId);
        //提前验收信息
        List<BizReformPilotManagement> advanceAcceptance = bizReformPilotManagementDao.advanceAcceptance(countDate, unitId);
        //实际验收信息
        List<BizReformPilotManagement> actualAcceptance = bizReformPilotManagementDao.actualAcceptance(countDate, unitId);
        //未验收信息
        List<BizReformPilotManagement> notAcceptance = bizReformPilotManagementDao.notAcceptance(countDate, unitId);
        AcceptanceVo acceptanceVo=new AcceptanceVo();
        acceptanceVo.setShouldAcceptanceList(shouldAcceptance);
        acceptanceVo.setAdvanceAcceptance(advanceAcceptance);
        acceptanceVo.setActualAcceptance(actualAcceptance);
        acceptanceVo.setNotAcceptance(notAcceptance);
        return acceptanceVo;
    }


}
