package com.artfess.reform.statistics.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.statistics.model.BizScoringProjectMeasure;
import com.artfess.reform.statistics.dao.BizScoringProjectMeasureDao;
import com.artfess.reform.statistics.manager.BizScoringProjectMeasureManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.vo.MeasureListVO;
import com.artfess.reform.utils.CumputeUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目具体措施推进力评分结果 服务实现类
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-14
 */
@Service
public class BizScoringProjectMeasureManagerImpl extends BaseManagerImpl<BizScoringProjectMeasureDao, BizScoringProjectMeasure> implements BizScoringProjectMeasureManager {
    @Resource
    private BizScoringProjectMeasureDao bizScoringProjectMeasureDao;

    @Override
    public IPage<MeasureListVO> select4Cockpit(QueryFilter<BizScoringProjectMeasure> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        LocalDateTime now = LocalDateTime.now();
        int year = now.getYear();
        Integer type = 1;
        List<QueryField> querys = queryFilter.getQuerys();
        for (QueryField query : querys) {
            if ("type".equals(query.getProperty())) {
                type = (Integer) query.getValue();
            }
        }

        return bizScoringProjectMeasureDao.select4Cockpit(convert2IPage(pageBean), type, year);
    }

    public List<BizScoringProjectMeasure> getList() {
        LocalDate now = LocalDate.now();
        LocalDate lastDay = now.with(TemporalAdjusters.lastDayOfMonth());
        List<BizScoringProjectMeasure> list = bizScoringProjectMeasureDao.statisticsNum(now.getYear(), null, null);
        if (list != null && list.size() > 0) {

            List<BigDecimal> regimeList = new ArrayList<>();//所有项目形成制度的完成率的集合
            List<BigDecimal> appPlatformList = new ArrayList<>();//所有项目搭建平台上线应用的完成率的集合
            for (BizScoringProjectMeasure scoringProjectMeasure : list) {
                BigDecimal regimeRate = new BigDecimal(scoringProjectMeasure.getActualRegimeNum()).divide(new BigDecimal(scoringProjectMeasure.getRegimeNum()), 2, BigDecimal.ROUND_HALF_UP);
                BigDecimal appPlatformRate = new BigDecimal(scoringProjectMeasure.getActualAppNum() + scoringProjectMeasure.getActualPlatformNum()).divide(new BigDecimal(scoringProjectMeasure.getAppNum() + scoringProjectMeasure.getPlatformNum()), 2,
                        BigDecimal.ROUND_HALF_UP);
                scoringProjectMeasure.setRegimeRate(regimeRate); //当前项目的形成制度的完成率
                scoringProjectMeasure.setAppPlatformRate(appPlatformRate);//当前项目的搭建平台上线应用的完成率
                regimeList.add(regimeRate);
                appPlatformList.add(appPlatformRate);
            }
            //计算
            CumputeUtil util = new CumputeUtil(3);
            for (BizScoringProjectMeasure scoringProjectMeasure : list) {
                BigDecimal regimeRate = scoringProjectMeasure.getRegimeRate();
                BigDecimal appPlatformRate = scoringProjectMeasure.getAppPlatformRate();
                //功效计算形成制度得分
                BigDecimal regimeScore = util.cumpute3(regimeList.toArray(new BigDecimal[regimeList.size()]), regimeRate, new BigDecimal(15), false);
                //功效计算搭建平台上线应用得分
                BigDecimal appPlatformScore = util.cumpute3(appPlatformList.toArray(new BigDecimal[appPlatformList.size()]), appPlatformRate, new BigDecimal(15), false);
                //形成制度得分+搭建平台上线应用得分 = 改革方案明确的具体举措推进力得分
                BigDecimal measureScore = regimeScore.add(appPlatformScore);

                scoringProjectMeasure.setMeasureScore(measureScore);
                scoringProjectMeasure.setAppPlatformScore(appPlatformScore);
                scoringProjectMeasure.setRegimeScore(regimeScore);
            }

            //查询上月的第一名
            BizScoringProjectMeasure NO1 = null;
            if (now.getMonthValue() != 1 && now.getDayOfMonth()==lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringProjectMeasure> queryWrapper = new QueryWrapper();
                queryWrapper.eq("HOLD_NUM_", 1);
                queryWrapper.eq("FILL_YEAR_", now.getYear());
                queryWrapper.eq("FILL_YEAR_", now.getMonthValue() - 1);
                queryWrapper.eq("FILL_TYPE_", "M");
                List<BizScoringProjectMeasure> NO1List = bizScoringProjectMeasureDao.selectList(queryWrapper);
                if (NO1List != null && NO1List.size() > 0) {
                    NO1 = NO1List.get(0);
                }
            }

            //排名
            list = list.stream().sorted((s1, s2) -> -s1.getMeasureScore().compareTo(s2.getMeasureScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringProjectMeasure>>> snlist = list.stream().collect(Collectors.groupingBy(BizScoringProjectMeasure::getMeasureScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;

            for (Map.Entry<BigDecimal, List<BizScoringProjectMeasure>> entry : snlist) {
                for (BizScoringProjectMeasure measure : entry.getValue()) {
                    measure.setMeasureSn(index);
                    //蝉联(每个月最后一天计算)
                    if (lastDay.getDayOfMonth() == now.getDayOfMonth()) {
                        if (NO1 == null && index == 1) {
                            measure.setHoldNum(0);
                        } else if (NO1 != null && !NO1.getProjectId().equals(measure.getProjectId()) && index == 1) {
                            measure.setHoldNum(0);
                        } else if (NO1 != null && NO1.getProjectId().equals(measure.getProjectId()) && index == 1) {
                            measure.setHoldNum(NO1.getHoldNum() + 1);
                        }
                    }

                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                //index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                index = ++index;
            }

        }
        return list;
    }

    @Override
    @Transactional
    public List<BizScoringProjectMeasure> countScore(LocalDate countDate) {
        LocalDate now =LocalDate.now();
        if(countDate==null){
            countDate = now;
        }
        LocalDate lastDay = countDate.with(TemporalAdjusters.lastDayOfMonth());

        List<BizScoringProjectMeasure> list = bizScoringProjectMeasureDao.statisticsNum(countDate.getYear(),null,null);
        if(list!=null && list.size()>0){
            List<BigDecimal> regimeList = new ArrayList<>();//所有项目形成制度的完成率的集合
            List<BigDecimal> appPlatformList = new ArrayList<>();//所有项目搭建平台上线应用的完成率的集合
            for(BizScoringProjectMeasure scoringProjectMeasure :list){
                scoringProjectMeasure.setFillDate(countDate);
                scoringProjectMeasure.setFillYear(countDate.getYear());
                scoringProjectMeasure.setFillQuarter(getSeasonDay(countDate));
                scoringProjectMeasure.setFillMonth(countDate.getMonthValue());
                scoringProjectMeasure.setFillType(getFillType(countDate));
                if(scoringProjectMeasure.getRegimeNum() !=0){
                    BigDecimal regimeRate =  new BigDecimal(scoringProjectMeasure.getActualRegimeNum()).divide(new BigDecimal(scoringProjectMeasure.getRegimeNum()),2, BigDecimal.ROUND_HALF_UP);
                    BigDecimal appPlatformRate =  new BigDecimal(scoringProjectMeasure.getActualAppNum()+scoringProjectMeasure.getActualPlatformNum()).divide(new BigDecimal(scoringProjectMeasure.getAppNum()+scoringProjectMeasure.getPlatformNum()),2,
                            BigDecimal.ROUND_HALF_UP);
                    scoringProjectMeasure.setRegimeRate(regimeRate); //当前项目的形成制度的完成率
                    scoringProjectMeasure.setAppPlatformRate(appPlatformRate);//当前项目的搭建平台上线应用的完成率
                    regimeList.add(regimeRate);
                    appPlatformList.add(appPlatformRate);
                }
            }
            //计算
            CumputeUtil util = new CumputeUtil(3);
            for(BizScoringProjectMeasure scoringProjectMeasure :list){
                BigDecimal regimeRate = scoringProjectMeasure.getRegimeRate();
                BigDecimal appPlatformRate =  scoringProjectMeasure.getAppPlatformRate();
                //功效计算形成制度得分
                BigDecimal regimeScore = util.cumpute3(regimeList.toArray(new BigDecimal[regimeList.size()]),regimeRate,new BigDecimal(15),false);
                //功效计算搭建平台上线应用得分
                BigDecimal appPlatformScore = util.cumpute3(appPlatformList.toArray(new BigDecimal[appPlatformList.size()]),appPlatformRate,new BigDecimal(15),false);
                //形成制度得分+搭建平台上线应用得分 = 改革方案明确的具体举措推进力得分
                BigDecimal measureScore = regimeScore.add(appPlatformScore);

                scoringProjectMeasure.setMeasureScore(measureScore);
                scoringProjectMeasure.setAppPlatformScore(appPlatformScore);
                scoringProjectMeasure.setRegimeScore(regimeScore);
            }

            //查询上月的第一名
            List<BizScoringProjectMeasure>  NO1List  =new ArrayList<>();
            if (countDate.getMonthValue() != 1 && countDate.getDayOfMonth()==lastDay.getDayOfMonth()) {
                QueryWrapper<BizScoringProjectMeasure> queryWrapper =new QueryWrapper();
                queryWrapper.eq("MEASURE_SN_", 1);
                queryWrapper.eq("FILL_YEAR_", countDate.getYear());
                queryWrapper.eq("FILL_MONTH_", countDate.getMonthValue()-1);
                queryWrapper.eq("FILL_TYPE_", "M");
                NO1List = bizScoringProjectMeasureDao.selectList(queryWrapper);
            }

            //排名
            list = list.stream().sorted((s1, s2) -> -s1.getMeasureScore().compareTo(s2.getMeasureScore())).collect(Collectors.toList());
            List<Map.Entry<BigDecimal, List<BizScoringProjectMeasure>>> snlist  = list.stream().collect(Collectors.groupingBy(BizScoringProjectMeasure::getMeasureScore)).entrySet()
                    .stream().sorted((s1, s2) -> -s1.getKey().compareTo(s2.getKey())).collect(Collectors.toList());
            Integer index = 1;

            for (Map.Entry<BigDecimal, List<BizScoringProjectMeasure>> entry : snlist) {
                for(BizScoringProjectMeasure measure : entry.getValue()){
                    measure.setMeasureSn(index);
                    //蝉联(每个月最后一天计算)
                    if(lastDay.getDayOfMonth() == countDate.getDayOfMonth()){
                        if((NO1List ==null|| NO1List.size()==0) && index==1){
                            measure.setHoldNum(0);
                        }else if((NO1List!=null && NO1List.size()>0) && index==1 ){
                            for(BizScoringProjectMeasure NO1:NO1List){
                                if(NO1.getProjectId().equals(measure.getProjectId())){
                                    measure.setHoldNum(NO1.getHoldNum()+1);
                                    break;
                                }else{
                                    measure.setHoldNum(0);
                                }
                            }
                        }
                    }
                }
                // 100 100 99 98 98 97 对应名次 1 1 3 4 4 6
                index = index + entry.getValue().size();
                // 100 100 99 98 98 97 对应名次 1 1 2 3 3 4
                //index = ++index;
            }
            QueryWrapper<BizScoringProjectMeasure> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("FILL_DATE_", countDate);
            bizScoringProjectMeasureDao.delete(queryWrapper);
            this.saveBatch(list);
        }
        return list;
    }

    public static String getFillType(LocalDate dateTime){
        String type = "D";
        int month = dateTime.getMonthValue();
        int day = dateTime.getDayOfMonth();
        LocalDate lastDay = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        if (day == lastDay.getDayOfMonth()) {
            type = "M";
            if(month == 3 ||month == 6 ||month == 9 ||month == 12 ){
                type = "Q";
            }
        }
        return type;
    }

    public static int getSeasonDay(LocalDate dateTime) {
        return Integer.valueOf(dateTime.getMonthValue()+2)/3;
    }
}
