package com.artfess.reform.statistics.manager;

import com.artfess.reform.statistics.model.BizScoringProjectSyn;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.statistics.model.BizScoringProjectTarget;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;

/**
 * 项目综合评分结果 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-13
 */
public interface BizScoringProjectSynManager extends BaseManager<BizScoringProjectSyn> {

    /**
     * 根据填报年度查询所有项目的综合报表
     * @param fillYear 填报年
     * @param fillMonth 填报月
     * @return
     */
    Map<String,Object> querySynReportByFillYearMonth(Integer fillYear, Integer fillMonth);


    /**
     * @Description: 计算项目综合评分结果
     * @param countDate
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringProjectSyn>
     * @Author: chens
     * @Date: 2023/4/24 15:51
     */
    List<BizScoringProjectSyn> countScore(LocalDate countDate);
}
