package com.artfess.reform.statistics.dao;

import com.artfess.reform.statistics.model.BizScoringCountySyn;
import com.artfess.reform.statistics.model.BizScoringCountyWorkable;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 区县落实改革力评分结果 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2023-03-27
 */
public interface BizScoringCountyWorkableDao extends BaseMapper<BizScoringCountyWorkable> {

    /**
    * @Description: 统计区县落实力数据
    * @param countDate 计算的时间
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyWorkable>
    * @Author: chens
    * @Date: 2023/4/5 21:43
    */
    List<BizScoringCountyWorkable> countPilot(@Param("countDate") LocalDate countDate);

    /**
     * @Description: 统计所有区县最新的评分结果的合计
     * @param fillYear 评比年
     * @param fillQuarter 评比季度
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    BizScoringCountyWorkable statisticsLatest(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter);

    /**
     * @Description: 统计试点项目个数
     * @param year 评比年
     * @param quarter 评比季度
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    BizScoringCountyWorkable statisticsPilotNum(@Param("year")Integer year, @Param("quarter")Integer quarter);

    /**
     * @Description: 查询最新的评分结果
     * @param fillYear 评比年
     * @param fillQuarter 评比季度
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @param unitCode  区县编码
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringCountyWorkable> queryLatest(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter, @Param("fillType") String fillType, @Param("unitCode") String unitCode);

    /**
     * @Description: 查询最新的改革落实力评分排名全市第一的结果
     * @param fillYear 评比年
     * @param fillQuarter 评比季度
     * @param fillType 评比类型（日：D，月：M，季度：Q，年：Y）
     * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyBrand>
     * @Author: chens
     * @Date: 2023/4/5 15:23
     */
    List<BizScoringCountyWorkable> queryLatestNo1(@Param("fillYear") Integer fillYear, @Param("fillQuarter") Integer fillQuarter, @Param("fillType") String fillType);


    /**
    * @Description: 查询区县的试点通过数据
    * @param
    * @param unitCode
    * @Return: java.util.List<com.artfess.reform.statistics.model.BizScoringCountyWorkable>
    * @Author: chens
    * @Date: 2023/4/6 11:12
    */
    List<BizScoringCountyWorkable> queryPassAndPush(@Param("year") Integer year, @Param("quarter") Integer quarter,@Param("unitCode") String unitCode);
}
