package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目具体举措计划推进情况
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */


@Data
@TableName("BIZ_PILOT_MEASURES_PUSH")
@ApiModel(value="BizPilotMeasuresPush对象", description="项目改革方案明确的计划（月度计划）推进情况")
public class PilotMeasuresPush extends AutoFillFullModel<PilotMeasuresPush> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "填报ID")
    @TableField("FILL_ID_")
    private String fillId;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

//    @ApiModelProperty(value = "举措明细计划ID（关联举措明细计划表ID）")
//    @TableField("MEASURES_ID_")
//    private String measuresId;

    @ApiModelProperty(value = "举措明细计划ID（关联月度计划表ID）")
    @TableField("PLAN_ID_")
    private String measuresId;

    @ApiModelProperty(value = "计划类型（使用字典，1：形成制度成果，2：搭建重要平台，3：上线应用场景）")
    @TableField("PLAN_TYPE_")
    private String planType;

    @ApiModelProperty(value = "是否完成（1：未启动，2：推进中，3：已完成）")
    @TableField("IS_OVER_")
    private String isOver;

    @ApiModelProperty(value = "已完成工作/成果名称")
    @TableField("COMPLETED_WORK_")
    private String completedWork;

    @ApiModelProperty(value = "存在问题")
    @TableField("PROBLEMS_")
    private String problems;

    @ApiModelProperty(value = "下步工作计划")
    @TableField("WORK_PLAN_")
    private String workPlan;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "审核状态（与填报表状态一致，0：草稿，1：已录入待审核，2：责任单位领导审核驳回，,3：责任单位领导审核通过，4：市委改革办审核驳回，5：市委改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDelete",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    private String isDelete = "0";

    @ApiModelProperty(value = "项目名称")
    @TableField(exist = false)
    private String projectName;

    @ApiModelProperty(value = "计划年份")
    @TableField(exist = false)
    private Integer planYear;

    @ApiModelProperty(value = "计划月份")
    @TableField(exist = false)
    private Integer planMonth;

    @ApiModelProperty(value = "计划内容")
    @TableField(exist = false)
    private String planContent;

    @ApiModelProperty(value = "文件")
    @TableField(exist = false)
    private List<DefaultFile> defaultFileList;
}
