package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.model.BizEffectDryingCompetition;
import com.artfess.reform.majorProjects.manager.*;
import com.artfess.reform.majorProjects.model.*;
import com.artfess.reform.majorProjects.dao.PilotProjectFillDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.vo.*;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 市级重大改革项目填报审核记录 服务实现类
 *
 * @author baseli
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-13
 */
@Service
public class BizPilotProjectFillManagerImpl extends BaseManagerImpl<PilotProjectFillDao, PilotProjectFill> implements PilotProjectFillManager {

    @Resource
    private SysDictionaryManager sysDictionaryManager;

    @Resource
    private AchieveStatusLogManager achieveStatusLogManager;

    @Resource
    private PilotProjectFillDao pilotProjectFillDao;

    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    @Override
    public PageList<PilotProjectFill> queryPageFillList(QueryFilter<PilotProjectFill> queryFilter, Integer flowType) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PilotProjectFill> result = baseMapper.queryPageFillList(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()), flowType);
        return new PageList<PilotProjectFill>(result);
    }

    @Override
    public PageList<PilotProjectFill> queryPageFillGroup(QueryFilter<PilotProjectFill> queryFilter, Integer flowType, String code) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PilotProjectFill> result = baseMapper.queryPageFillGroup(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()), flowType,code);
        return new PageList<PilotProjectFill>(result);
    }

//    @Override
//    public PilotProjectFillQueryVo getDetails(String id) {
//        return null;
//    @Transactional
//    public void saveVo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        Assert.notNull(pilotProjectFillCreateVo, "保存数据不能为空");
//        // 1.保存填报信息
//        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
//        Assert.notNull(pilotProjectFill, "填报审核记录数据不能为空");
//        Assert.notNull(pilotProjectFill.getProjectId(), "填报审核记录未关联项目【projectId】");
//        LocalDate fillDate = pilotProjectFill.getFillDate();
//        Assert.notNull(fillDate, "填报日期不能为空");
//        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
//        pilotProjectFill.setFillYear(fillDate.getYear());
//        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
//        pilotProjectFill.setFillQuarter(quarter);
//        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
//        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
//        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
//        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
//        pilotProjectFill.setStatus(0);
//        this.saveOrUpdate(pilotProjectFill);
//        // 2.保存量化目标推进情况集合
//        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotProjectFillCreateVo.getPilotQuantitativeObjectivesPushList();
//        if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0) {
//            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                if (p.getPushDate() == null) {
//                    p.setPushDate(fillDate);
//                    p.setPushYear(fillDate.getYear());
//                    p.setPushMonth(fillDate.getMonthValue());
//                    p.setPushQuarter(quarter);
//                }else {
//                    p.setPushQuarter((p.getPushDate().getMonthValue() - 1) / 3 + 1);
//                }
//                // 计算达标率,达标率=当前值÷年度总值
//                // 推进当前值
//                BigDecimal pushProgress = p.getPushProgress();
//                // 推进年份
//                Integer pushYear = p.getPushYear();
//                String objectivesMeasuresId = p.getObjectivesMeasuresId();
//                if(null != pushYear && StringUtils.isNotBlank(objectivesMeasuresId) && pushProgress != null){
//                    BigDecimal detailsYearValue = pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
//                    if(null != detailsYearValue){
//                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, BigDecimal.ROUND_HALF_UP);
//                        p.setComplianceRate(divide);
//                    }
//                }
//
//            });
//            pilotQuantitativeObjectivesPushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
//        }
//        // 3.项目具体举措计划推进情况集合
//        List<PilotMeasuresPush> pilotMeasuresPushList = pilotProjectFillCreateVo.getPilotMeasuresPushList();
//        if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
//            pilotMeasuresPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            pilotMeasuresPushManager.saveOrUpdateBatch(pilotMeasuresPushList);
//        }
//        // 4.项目经验推广总结情况集合
//        List<PilotExperiencePush> pilotExperiencePushList = pilotProjectFillCreateVo.getPilotExperiencePushList();
//        if (null != pilotExperiencePushList && pilotExperiencePushList.size() > 0) {
//            pilotExperiencePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            pilotExperiencePushManager.saveOrUpdateList(pilotExperiencePushList);
//        }
//        // 5.进度计划明细推进情况集合
//        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotProjectFillCreateVo.getPilotSpecificSchedulePushList();
//        if (null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0) {
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            pilotSpecificSchedulePushManager.saveOrUpdateBatch(pilotSpecificSchedulePushList);
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                List<DefaultFile> defaultFileList = p.getDefaultFileList();
//                if (null != defaultFileList && defaultFileList.size() > 0) {
//                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
//                    // 修改附件bizId
//                    fileManager.updateFileBizIdByIds(fileList, p.getId());
//                }
//            });
//        }
//        // 6.项目品牌显示度情况集合
//        List<PilotBrandPush> pilotBrandPushList = pilotProjectFillCreateVo.getPilotBrandPushList();
//        if (null != pilotBrandPushList && pilotBrandPushList.size() > 0) {
//            pilotBrandPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotBrandPushManager.saveOrUpdateBatch(pilotBrandPushList);
//        }
//    }
//
//    @Override
//    public PilotProjectFillQueryVo getDraftDetails(String projectId) {
//        // 如果没有传入ID则查询上一次审核通过的记录
//        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("PROJECT_ID_", projectId);
//        queryWrapper.eq("STATUS_", 0);
//        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.orderByDesc("FILL_YEAR_", "FILL_MONTH_, CREATE_TIME_");
//        queryWrapper.last(" limit 1");
//        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
//        if (null != pilotProjectFill && StringUtils.isNotBlank(pilotProjectFill.getId())) {
//            return this.getDetails(pilotProjectFill.getId());
//        }
//        return null;
//    }
//}
//    @Transactional
//    public void commitVo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        Assert.notNull(pilotProjectFillCreateVo, "保存数据不能为空");
//        // 1.保存填报信息
//        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
//        Assert.notNull(pilotProjectFill, "填报审核记录数据不能为空");
//        Assert.notNull(pilotProjectFill.getProjectId(), "填报审核记录未关联项目【projectId】");
//        LocalDate fillDate = pilotProjectFill.getFillDate();
//        Assert.notNull(fillDate, "填报日期不能为空");
//        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
//        pilotProjectFill.setFillYear(fillDate.getYear());
//        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
//        pilotProjectFill.setFillQuarter(quarter);
//        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
//        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
//        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
//        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
//        pilotProjectFill.setStatus(1);
//        this.saveOrUpdate(pilotProjectFill);
//        // 2.保存量化目标推进情况集合
//        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotProjectFillCreateVo.getPilotQuantitativeObjectivesPushList();
//        if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0) {
//            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                if (p.getPushDate() == null) {
//                    p.setPushDate(fillDate);
//                    p.setPushYear(fillDate.getYear());
//                    p.setPushMonth(fillDate.getMonthValue());
//                    p.setPushQuarter(quarter);
//                }else {
//                    p.setPushQuarter((p.getPushDate().getMonthValue() - 1) / 3 + 1);
//                }
//                // 计算达标率,达标率=当前值÷年度总值
//                // 推进当前值
//                BigDecimal pushProgress = p.getPushProgress();
//                // 推进年份
//                Integer pushYear = p.getPushYear();
//                String objectivesMeasuresId = p.getObjectivesMeasuresId();
//                if(null != pushYear && StringUtils.isNotBlank(objectivesMeasuresId) && pushProgress != null){
//                    BigDecimal detailsYearValue = pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
//                    if(null != detailsYearValue){
//                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, BigDecimal.ROUND_HALF_UP);
//                        p.setComplianceRate(divide);
//                    }
//                }
//            });
//            pilotQuantitativeObjectivesPushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
//        }
//        // 3.项目具体举措计划推进情况集合
//        List<PilotMeasuresPush> pilotMeasuresPushList = pilotProjectFillCreateVo.getPilotMeasuresPushList();
//        if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
//            pilotMeasuresPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotMeasuresPushManager.saveOrUpdateBatch(pilotMeasuresPushList);
//        }
//        // 4.项目经验推广总结情况集合
//        List<PilotExperiencePush> pilotExperiencePushList = pilotProjectFillCreateVo.getPilotExperiencePushList();
//        if (null != pilotExperiencePushList && pilotExperiencePushList.size() > 0) {
//            pilotExperiencePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotExperiencePushManager.saveOrUpdateBatch(pilotExperiencePushList);
//        }
//        // 5.进度计划明细推进情况集合
//        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotProjectFillCreateVo.getPilotSpecificSchedulePushList();
//        if (null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0) {
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//            });
//            pilotSpecificSchedulePushManager.saveOrUpdateBatch(pilotSpecificSchedulePushList);
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                List<DefaultFile> defaultFileList = p.getDefaultFileList();
//                if (null != defaultFileList && defaultFileList.size() > 0) {
//                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
//                    // 修改附件bizId
//                    fileManager.updateFileBizIdByIds(fileList, p.getId());
//                }
//            });
//        }
//        // 6.项目品牌显示度情况集合
//        List<PilotBrandPush> pilotBrandPushList = pilotProjectFillCreateVo.getPilotBrandPushList();
//        if (null != pilotBrandPushList && pilotBrandPushList.size() > 0) {
//            pilotBrandPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotBrandPushManager.saveOrUpdateBatch(pilotBrandPushList);
//        }
//        createLog(pilotProjectFill, "提交", "提交数据");
//    }

    @Override
    @Transactional
    public void examineVo(FillPushExamineVo fillPushExamineVo) {
        Assert.notNull(fillPushExamineVo, "审核数据不能为空");
        Assert.notNull(fillPushExamineVo.getId(), "审核填报数据不能为空");
        Assert.notNull(fillPushExamineVo.getStatus(), "审核数据状态不能为空");
        UpdateWrapper<PilotProjectFill> pilotProjectFillUpdateWrapper = new UpdateWrapper<>();
        pilotProjectFillUpdateWrapper.set("STATUS_", fillPushExamineVo.getStatus()).eq("ID_", fillPushExamineVo.getId());
        this.update(pilotProjectFillUpdateWrapper);

        PilotProjectFill pilotProjectFill = this.baseMapper.selectById(fillPushExamineVo.getId());
        pilotProjectFill.setStatus(fillPushExamineVo.getStatus());
        pilotProjectFill.setApprovalComments(fillPushExamineVo.getApprovalComments());
        pilotProjectFill.setApprovalResults(fillPushExamineVo.getApprovalResults());
        pilotProjectFill.setFlowType(fillPushExamineVo.getFlowType());

        this.createLog(pilotProjectFill, fillPushExamineVo.getTitle());
        // 审批过后的一些字段处理
//        this.examineFinshHandle(fillPushExamineVo.getId());
    }

//    @Override
//    @Transactional
//    public void saveVo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        Assert.notNull(pilotProjectFillCreateVo, "保存数据不能为空");
//        // 1.保存填报信息
//        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
//        Assert.notNull(pilotProjectFill, "填报审核记录数据不能为空");
//        Assert.notNull(pilotProjectFill.getProjectId(), "填报审核记录未关联项目【projectId】");
//        LocalDate fillDate = pilotProjectFill.getFillDate();
//        Assert.notNull(fillDate, "填报日期不能为空");
//        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
//        pilotProjectFill.setFillYear(fillDate.getYear());
//        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
//        pilotProjectFill.setFillQuarter(quarter);
//        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
//        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
//        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
//        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
//        pilotProjectFill.setStatus(0);
//        this.saveOrUpdate(pilotProjectFill);
//        // 2.保存量化目标推进情况集合
//        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotProjectFillCreateVo.getPilotQuantitativeObjectivesPushList();
//        if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0) {
//            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                if (p.getPushDate() == null) {
//                    p.setPushDate(fillDate);
//                    p.setPushYear(fillDate.getYear());
//                    p.setPushMonth(fillDate.getMonthValue());
//                    p.setPushQuarter(quarter);
//                }else {
//                    p.setPushQuarter((p.getPushDate().getMonthValue() - 1) / 3 + 1);
//                }
//                // 计算达标率,达标率=当前值÷年度总值
//                // 推进当前值
//                BigDecimal pushProgress = p.getPushProgress();
//                // 推进年份
//                Integer pushYear = p.getPushYear();
//                String objectivesMeasuresId = p.getObjectivesMeasuresId();
//                if(null != pushYear && StringUtils.isNotBlank(objectivesMeasuresId) && pushProgress != null){
//                    BigDecimal detailsYearValue = pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
//                    if(null != detailsYearValue){
//                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, BigDecimal.ROUND_HALF_UP);
//                        p.setComplianceRate(divide);
//                    }
//                }
//
//            });
//            pilotQuantitativeObjectivesPushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
//        }
//        // 3.项目具体举措计划推进情况集合
//        List<PilotMeasuresPush> pilotMeasuresPushList = pilotProjectFillCreateVo.getPilotMeasuresPushList();
//        if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
//            pilotMeasuresPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            pilotMeasuresPushManager.saveOrUpdateBatch(pilotMeasuresPushList);
//        }
//        // 4.项目经验推广总结情况集合
//        List<PilotExperiencePush> pilotExperiencePushList = pilotProjectFillCreateVo.getPilotExperiencePushList();
//        if (null != pilotExperiencePushList && pilotExperiencePushList.size() > 0) {
//            pilotExperiencePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            pilotExperiencePushManager.saveOrUpdateBatch(pilotExperiencePushList);
//        }
//        // 5.进度计划明细推进情况集合
//        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotProjectFillCreateVo.getPilotSpecificSchedulePushList();
//        if (null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0) {
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//
//            });
//            pilotSpecificSchedulePushManager.saveOrUpdateBatch(pilotSpecificSchedulePushList);
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                List<DefaultFile> defaultFileList = p.getDefaultFileList();
//                if (null != defaultFileList && defaultFileList.size() > 0) {
//                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
//                    // 修改附件bizId
//                    fileManager.updateFileBizIdByIds(fileList, p.getId());
//                }
//            });
//        }
//        // 6.项目品牌显示度情况集合
//        List<PilotBrandPush> pilotBrandPushList = pilotProjectFillCreateVo.getPilotBrandPushList();
//        if (null != pilotBrandPushList && pilotBrandPushList.size() > 0) {
//            pilotBrandPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotBrandPushManager.saveOrUpdateBatch(pilotBrandPushList);
//        }
//    }
//
//    @Override
//    @Transactional
//    public void commitVo(PilotProjectFillCreateVo pilotProjectFillCreateVo) {
//        Assert.notNull(pilotProjectFillCreateVo, "保存数据不能为空");
//        // 1.保存填报信息
//        PilotProjectFill pilotProjectFill = pilotProjectFillCreateVo.getPilotProjectFill();
//        Assert.notNull(pilotProjectFill, "填报审核记录数据不能为空");
//        Assert.notNull(pilotProjectFill.getProjectId(), "填报审核记录未关联项目【projectId】");
//        LocalDate fillDate = pilotProjectFill.getFillDate();
//        Assert.notNull(fillDate, "填报日期不能为空");
//        int quarter = (fillDate.getMonthValue() - 1) / 3 + 1;
//        pilotProjectFill.setFillYear(fillDate.getYear());
//        pilotProjectFill.setFillMonth(fillDate.getMonthValue());
//        pilotProjectFill.setFillQuarter(quarter);
//        pilotProjectFill.setUnitId(ContextUtil.getCurrentOrgId());
//        pilotProjectFill.setUnitName(ContextUtil.getCurrentOrgName());
//        pilotProjectFill.setUnitCode(ContextUtil.getCurrentOrgCode());
//        pilotProjectFill.setUnitGrade(ContextUtil.getCurrentOrgGrade());
//        pilotProjectFill.setStatus(1);
//        this.saveOrUpdate(pilotProjectFill);
//        // 2.保存量化目标推进情况集合
//        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotProjectFillCreateVo.getPilotQuantitativeObjectivesPushList();
//        if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0) {
//            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                if (p.getPushDate() == null) {
//                    p.setPushDate(fillDate);
//                    p.setPushYear(fillDate.getYear());
//                    p.setPushMonth(fillDate.getMonthValue());
//                    p.setPushQuarter(quarter);
//                }else {
//                    p.setPushQuarter((p.getPushDate().getMonthValue() - 1) / 3 + 1);
//                }
//                // 计算达标率,达标率=当前值÷年度总值
//                // 推进当前值
//                BigDecimal pushProgress = p.getPushProgress();
//                // 推进年份
//                Integer pushYear = p.getPushYear();
//                String objectivesMeasuresId = p.getObjectivesMeasuresId();
//                if(null != pushYear && StringUtils.isNotBlank(objectivesMeasuresId) && pushProgress != null){
//                    BigDecimal detailsYearValue = pilotObjectivesDetailsManager.getYearValue(pushYear, objectivesMeasuresId);
//                    if(null != detailsYearValue){
//                        BigDecimal divide = pushProgress.divide(detailsYearValue, 4, BigDecimal.ROUND_HALF_UP);
//                        p.setComplianceRate(divide);
//                    }
//                }
//            });
//            pilotQuantitativeObjectivesPushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
//        }
//        // 3.项目具体举措计划推进情况集合
//        List<PilotMeasuresPush> pilotMeasuresPushList = pilotProjectFillCreateVo.getPilotMeasuresPushList();
//        if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
//            pilotMeasuresPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotMeasuresPushManager.saveOrUpdateBatch(pilotMeasuresPushList);
//        }
//        // 4.项目经验推广总结情况集合
//        List<PilotExperiencePush> pilotExperiencePushList = pilotProjectFillCreateVo.getPilotExperiencePushList();
//        if (null != pilotExperiencePushList && pilotExperiencePushList.size() > 0) {
//            pilotExperiencePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotExperiencePushManager.saveOrUpdateBatch(pilotExperiencePushList);
//        }
//        // 5.进度计划明细推进情况集合
//        List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotProjectFillCreateVo.getPilotSpecificSchedulePushList();
//        if (null != pilotSpecificSchedulePushList && pilotSpecificSchedulePushList.size() > 0) {
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//            });
//            pilotSpecificSchedulePushManager.saveOrUpdateBatch(pilotSpecificSchedulePushList);
//            pilotSpecificSchedulePushList.stream().forEach(p -> {
//                List<DefaultFile> defaultFileList = p.getDefaultFileList();
//                if (null != defaultFileList && defaultFileList.size() > 0) {
//                    List<String> fileList = defaultFileList.stream().map(f -> f.getId()).collect(Collectors.toList());
//                    // 修改附件bizId
//                    fileManager.updateFileBizIdByIds(fileList, p.getId());
//                }
//            });
//        }
//        // 6.项目品牌显示度情况集合
//        List<PilotBrandPush> pilotBrandPushList = pilotProjectFillCreateVo.getPilotBrandPushList();
//        if (null != pilotBrandPushList && pilotBrandPushList.size() > 0) {
//            pilotBrandPushList.stream().forEach(p -> {
//                p.setFillId(pilotProjectFill.getId());
//                p.setIsDelete("0");
//            });
//            pilotBrandPushManager.saveOrUpdateBatch(pilotBrandPushList);
//        }
////        createLog(pilotProjectFill, "提交", "提交数据");
//    }
//
//    @Override
//    @Transactional
//    public void examineVo(FillPushExamineVo fillPushExamineVo) {
//        Assert.notNull(fillPushExamineVo, "审核数据不能为空");
//        Assert.notNull(fillPushExamineVo.getId(), "审核填报数据不能为空");
//        Assert.notNull(fillPushExamineVo.getStatus(), "审核数据状态不能为空");
//        UpdateWrapper<PilotProjectFill> pilotProjectFillUpdateWrapper = new UpdateWrapper<>();
//        pilotProjectFillUpdateWrapper.set("STATUS_", fillPushExamineVo.getStatus()).eq("ID_", fillPushExamineVo.getId());
//        this.update(pilotProjectFillUpdateWrapper);
//        PilotProjectFill pilotProjectFill = new PilotProjectFill();
//        pilotProjectFill.setId(fillPushExamineVo.getId());
//        pilotProjectFill.setStatus(fillPushExamineVo.getStatus());
////        createLog(pilotProjectFill, "审核", fillPushExamineVo.getApprovalComments());
//        // 审批过后的一些字段处理
//        this.examineFinshHandle(fillPushExamineVo.getId());
//    }
//
//    /**
//     * 审核完成后的一些操作，根据填报ID查询推进数据，并更新某些数字
//     * 更新目标表，最新完成率、最新目标值、最新提交时间、推进状态根据状态值进行更新（如果当前目标值与年度目标值相等则说明已完成）
//     * 更新目标推进表字表最新完成率、推进状态
//     * @param id 填报ID
//     */
//    @Async
//    public void examineFinshHandle(String id){
//        // 1. 更新目标表，最新完成率、最新目标值、最新更新时间、推进状态根据状态值进行更新（如果当前目标值与年度目标值相等则说明已完成）
//        PilotProjectFillQueryVo details = this.getDetails(id);
//        if(null == details){
//            return;
//        }
//        PilotProjectFill pilotProjectFill = details.getPilotProjectFill();
//        if(null == pilotProjectFill){
//            return;
//        }
//        /**
//         * 审核中：
//         *    1.则将目标表中状态改为推进中
//         *    2.主项目状态为推进中
//         */
//
//        /**
//         * 审核完成：
//         *   // 1. 将最新完成率、最新进度值从目标推进表 更新到目标表中，
//         *   // 2. 如果当前值大于年度目标值，则将目标表中状态改为已完成，否则就是推进中
//         */

        /*
        if(5 == pilotProjectFill.getStatus()) {
            // 1.查询当前推进时间的年度目标值
            LocalDate pushDate = pilotQuantitativeObjectivesPush.getPushDate();
            if(null != pushDate){
                QueryWrapper<PilotObjectivesDetails> pilotObjectivesDetailsQueryWrapper = new QueryWrapper<>();
                pilotObjectivesDetailsQueryWrapper.eq("YEAR_", pushDate.getYear()).eq("OBJECTIVES_ID_", objectivesMeasuresId);
                List<PilotObjectivesDetails> pilotObjectivesDetailsList = pilotObjectivesDetailsManager.list(pilotObjectivesDetailsQueryWrapper);
                if(null != pilotObjectivesDetailsList && pilotObjectivesDetailsList.size() > 0){
                    PilotObjectivesDetails pilotObjectivesDetails = pilotObjectivesDetailsList.get(0);
                    BigDecimal yearValue = pilotObjectivesDetails.getYearValue();
                    if(null != yearValue && pilotQuantitativeObjectivesPush.getPushProgress() != null){
                        if(yearValue.compareTo(BigDecimal.ZERO) == 0){
                            pilotQuantitativeObjectives.setComplianceRate(BigDecimal.ZERO);
                        }else {
                            // 最新完成率 = 当前完成目标值 ÷ 年度目标值
                            BigDecimal complianceRate = pilotQuantitativeObjectivesPush.getPushProgress()
                                    .divide(yearValue, 4, BigDecimal.ROUND_HALF_UP);
//                                    pilotQuantitativeObjectives.setComplianceRate(complianceRate.stripTrailingZeros());

                            // 更新最新完成率、当前最新完成值、最新状态（已完成）
                            UpdateWrapper<PilotQuantitativeObjectives> pilotQuantitativeObjectivesUpdateWrapper = new UpdateWrapper<>();
                            pilotQuantitativeObjectivesUpdateWrapper.set("COMPLIANCE_RATE_", complianceRate.stripTrailingZeros())
                                    .set("REFORM_QUANTITATIVE_OBJECTIVES_VALUE_",  pilotQuantitativeObjectivesPush.getPushProgress());
                            if(pilotQuantitativeObjectivesPush.getPushProgress().compareTo(yearValue) == 0
                                    || pilotQuantitativeObjectivesPush.getPushProgress().compareTo(yearValue) > 0){
                                pilotQuantitativeObjectivesUpdateWrapper.set("PROGRESS_STATUS_", 3);
                            }
                            pilotQuantitativeObjectivesUpdateWrapper.eq("ID_", pilotQuantitativeObjectives.getId());
                            pilotQuantitativeObjectivesManager.update(pilotQuantitativeObjectivesUpdateWrapper);

                        }
                    }
                }
            }
        }else {
            // 更新目标状态（进行中）
            UpdateWrapper<PilotQuantitativeObjectives> pilotQuantitativeObjectivesUpdateWrapper = new UpdateWrapper<>();
            pilotQuantitativeObjectivesUpdateWrapper.set("PROGRESS_STATUS_", 2).eq("ID_", pilotQuantitativeObjectives.getId());
            pilotQuantitativeObjectivesManager.update(pilotQuantitativeObjectivesUpdateWrapper);
        }
        */
        // 2. 更新目标推进表子表，最新完成率、推进状态

//    }
//
    @Override
    public PageList<PilotProjectFillQueryVo> queyrList(QueryFilter<PilotProjectFill> queryFilter) {
        Assert.notNull(queryFilter, "条件格式不能为空");
        List<PilotProjectFillQueryVo> pilotProjectFillQueryVoList = new ArrayList<>();
        IPage<PilotProjectFill> ipageResult = pilotProjectFillDao
                .queryList(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
//                PageList<PilotProjectFill> pilotProjectFillPageList = this.query(queryFilter);
        PageList<PilotProjectFill> pilotProjectFillPageList = new PageList<>(ipageResult);
        List<PilotProjectFill> rows = pilotProjectFillPageList.getRows();
        if (null != rows && rows.size() > 0) {
            rows.stream().forEach(p -> {
                PilotProjectFillQueryVo vo = new PilotProjectFillQueryVo();
                vo.setPilotProjectFill(p);
                // 項目信息
//                MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
//                        .getExamineById(p);
                MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
                        .getMunicipalMajorProjectManagement(p.getProjectId());
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                // 根据审核ID查询其他审核信息，项目信息、目标信息 、举措信息、季度计划信息
                /*
                PilotProjectFillQueryVo details = getDetails(p.getId());
                vo.setMunicipalMajorProjectManagement(details.getMunicipalMajorProjectManagement());
                vo.setPilotQuantitativeObjectivesPushList(details.getPilotQuantitativeObjectivesPushList());
                vo.setPilotMeasuresPushList(details.getPilotMeasuresPushList());
                vo.setPilotBrandPushList(details.getPilotBrandPushList());
                vo.setPilotMeasuresPushList(details.getPilotMeasuresPushList());
                vo.setPilotExperiencePushList(details.getPilotExperiencePushList());

                 */
                pilotProjectFillQueryVoList.add(vo);
            });
        }
        PageList<PilotProjectFillQueryVo> result = new PageList<>();
        result.setRows(pilotProjectFillQueryVoList);
        result.setPage(pilotProjectFillPageList.getPage());
        result.setPageSize(pilotProjectFillPageList.getPageSize());
        result.setTotal(pilotProjectFillPageList.getTotal());
        return result;
    }

    @Override
    public PageList<QuantitativeObjectivesPushFillQueryVo> queyrQuantitativeObjectivesPushFillList(QueryFilter<PilotProjectFill> queryFilter) {
        Assert.notNull(queryFilter, "条件格式不能为空");
        List<QuantitativeObjectivesPushFillQueryVo> pilotProjectFillQueryVoList = new ArrayList<>();
        IPage<PilotProjectFill> ipageResult = pilotProjectFillDao
                .queryList(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
//                PageList<PilotProjectFill> pilotProjectFillPageList = this.query(queryFilter);
        PageList<PilotProjectFill> pilotProjectFillPageList = new PageList<>(ipageResult);
        List<PilotProjectFill> rows = pilotProjectFillPageList.getRows();
        if (null != rows && rows.size() > 0) {
            rows.stream().forEach(p -> {
                QuantitativeObjectivesPushFillQueryVo vo = new QuantitativeObjectivesPushFillQueryVo();
                vo.setPilotProjectFill(p);
                MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
                        .getMunicipalMajorProjectManagement(p.getProjectId());
                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
                pilotProjectFillQueryVoList.add(vo);
            });
        }
        PageList<QuantitativeObjectivesPushFillQueryVo> result = new PageList<>();
        result.setRows(pilotProjectFillQueryVoList);
        result.setPage(pilotProjectFillPageList.getPage());
        result.setPageSize(pilotProjectFillPageList.getPageSize());
        result.setTotal(pilotProjectFillPageList.getTotal());
        return result;
    }
//
//    @Override
//    public PilotProjectFillQueryVo getDetails(String id) {
//        Assert.notNull(id, "条件格式不能为空");
//        PilotProjectFillQueryVo pilotProjectFillQueryVo = new PilotProjectFillQueryVo();
//        PilotProjectFill pilotProjectFill = this.get(id);
//        pilotProjectFillQueryVo.setPilotProjectFill(pilotProjectFill);
//        if (null != pilotProjectFill) {
//            // 項目信息
//            MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
//                    .getExamineById(pilotProjectFill);
//            pilotProjectFillQueryVo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
//
//            // 量化目标推进情况集合（包括目标信息、填报年度信息、填报月度）
//            List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectivesPushManager
//                    .queryListByFillId(pilotProjectFill.getId());
//            // 设置对应年度、月度值
//            LocalDate fillDate = pilotProjectFill.getFillDate();
//            if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0 && null != fillDate) {
//                pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
//                    List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
//                            .eq("OBJECTIVES_ID_", p.getObjectivesMeasuresId()).eq("YEAR_", fillDate.getYear()));
//                    if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
//                        PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetails.get(0);
//                        // 设置年度值
//                        p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
//                        // 设置月度值
//
//                        try {
//                            Map map = beanToMap(pilotObjectivesDetails1);
//                            Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(fillDate.getMonthValue())));
//                            if (null != o) {
//                                BigDecimal mouthValue = (BigDecimal) o;
//                                p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
//                            }
//                        } catch (IllegalAccessException e) {
//                            e.printStackTrace();
//                        }
//                    }
//                });
//            }
//            pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
//            // 项目具体举措计划推进情况集合，包括具体季度的计划
//            List<PilotMeasuresPushVo> pilotMeasuresPushList = pilotMeasuresPushManager.queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotMeasuresPushList(pilotMeasuresPushList);
//            // 按照季度处理季度计划数据
//            List<Map<String, List<PilotMeasuresPushVo>>> pilotSpecificScheduleQuarterList = new ArrayList<>();
//            if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
//                Map<String, List<PilotMeasuresPushVo>> map = new LinkedHashMap<>();
//                for (PilotMeasuresPushVo vo : pilotMeasuresPushList) {
//                    String planQuarter = String.valueOf(vo.getPlanQuarter());
//                    List<PilotMeasuresPushVo> pilotMeasuresPushVos = map.get(planQuarter);
//                    if (null == pilotMeasuresPushVos) {
//                        pilotMeasuresPushVos = new ArrayList<>();
//                        pilotMeasuresPushVos.add(vo);
//                        map.put(planQuarter, pilotMeasuresPushVos);
//                    } else {
//                        pilotMeasuresPushVos.add(vo);
//                        map.put(planQuarter, pilotMeasuresPushVos);
//                    }
//                }
//                if (null != map && map.size() > 0) {
//                    for (String key : map.keySet()) {
//                        Map<String, List<PilotMeasuresPushVo>> subMap = new LinkedHashMap<>();
//                        subMap.put(key, map.get(key));
//                        pilotSpecificScheduleQuarterList.add(subMap);
//                    }
//                }
//            }
//            pilotProjectFillQueryVo.setPilotMeasuresPushQuarterList(pilotSpecificScheduleQuarterList);
//
//            //项目经验推广总结情况集合
//            List<PilotExperiencePush> pilotExperiencePushList = pilotExperiencePushManager.queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotExperiencePushList(pilotExperiencePushList);
//
//            // 进度计划明细推进情况集合
//            List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotSpecificSchedulePushManager
//                    .queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotSpecificSchedulePushList(pilotSpecificSchedulePushList);
//
//            // 项目品牌显示度情况集合
//            List<PilotBrandPush> pilotBrandPushList = pilotBrandPushManager.queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotBrandPushList(pilotBrandPushList);
//        } else {
//            throw new BaseException("未找到相关审核信息");
//        }
//        return pilotProjectFillQueryVo;
//    }
//
//    @Override
//    public PilotProjectFillQueryVo getHistoryDetails(String projectId) {
//        Assert.notNull(projectId, "项目ID不能为空");
//        // 如果没有传入ID则查询上一次审核通过的记录
//        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("PROJECT_ID_", projectId);
//        queryWrapper.eq("STATUS_", 5);
//        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.orderByDesc("FILL_YEAR_", "FILL_MONTH_", "CREATE_TIME_");
//        queryWrapper.last(" limit 1");
//        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
//        if (null != pilotProjectFill && StringUtils.isNotBlank(pilotProjectFill.getId())) {
//            return this.getDetails(pilotProjectFill.getId());
//        }
//        return new PilotProjectFillQueryVo();
//    }

    @Override
    public PilotProjectFill getHistoryPilotProjectFill(String projectId) {
        Assert.notNull(projectId, "项目ID不能为空");
        // 如果没有传入ID则查询上一次审核通过的记录
        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PROJECT_ID_", projectId);
        queryWrapper.eq("STATUS_", 5);
        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.orderByDesc("FILL_YEAR_", "FILL_MONTH_", "CREATE_TIME_");
        queryWrapper.orderByDesc("FILL_DATE_", "CREATE_TIME_");
        queryWrapper.last(" limit 1");
        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
        return pilotProjectFill;
    }

    @Override
    public PilotProjectFill getHistoryPilotProjectFill(String projectId, Integer flowType) {
        Assert.notNull(projectId, "项目ID不能为空");
        // 如果没有传入ID则查询上一次审核通过的记录
        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PROJECT_ID_", projectId);
        queryWrapper.in("STATUS_", 2,4,5);
        queryWrapper.eq("IS_DELE_", 0);
        queryWrapper.eq("FLOW_TYPE_", flowType);
//        queryWrapper.orderByDesc("FILL_YEAR_", "FILL_MONTH_", "CREATE_TIME_");
        queryWrapper.orderByDesc("FILL_DATE_", "CREATE_TIME_");
        queryWrapper.last(" limit 1");
        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
        return pilotProjectFill;
    }

    @Override
    public PilotProjectFill getHistoryPilotProjectFill(String projectId, Integer flowType, LocalDate fillDate) {
        Assert.notNull(projectId, "项目ID不能为空");
        if(null == fillDate){
            fillDate = LocalDate.now();
        }
        LocalDate end = fillDate.with(TemporalAdjusters.lastDayOfMonth());
        LocalDate start = fillDate.with(TemporalAdjusters.firstDayOfMonth());
        // 如果没有传入ID则查询上一次审核通过的记录
        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PROJECT_ID_", projectId);
        queryWrapper.in("STATUS_", 2,4,5);
        queryWrapper.eq("IS_DELE_", 0);
        queryWrapper.eq("FLOW_TYPE_", flowType);
        queryWrapper.ge("FILL_DATE_", start);
        queryWrapper.le("FILL_DATE_", end);
        queryWrapper.orderByDesc("FILL_DATE_", "CREATE_TIME_");
        queryWrapper.last(" limit 1");
        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
        return pilotProjectFill;
    }






//
//    @Override
//    public boolean haveExamine(String projectId) {
//        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("PROJECT_ID_", projectId);
//        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.gt("STATUS_", 0);
//        queryWrapper.lt("STATUS_", 5);
//        int count = this.count(queryWrapper);
//        if (count > 0) {
//            return true;
//        }
//        return false;
//    }
//

//
//    /**
//     * @param pilotProjectFill
//     * @param title
//     * @param approvalComments
//     */
//    public void createLog(PilotProjectFill pilotProjectFill, String title, String approvalComments) {
//        List<Integer> statusList = Arrays.asList(1, 3, 5);
//        // 审批日志
//        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
//        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
//        logVo.setBizId(pilotProjectFill.getId());
//        logVo.setModeType(6);
//        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");
//        logVo.setItemTitle("市级重大改革项目【市级重大改革项目填报审核记录】" + title);
//        // 字典数据 shzt
//        logVo.setStatus(String.valueOf(pilotProjectFill.getStatus()));
//        logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, pilotProjectFill.getStatus()));
//        if (null != pilotProjectFill.getStatus() && statusList.contains(pilotProjectFill.getStatus())) {
//            logVo.setApprovalResults(0);
//        } else {
//            logVo.setApprovalResults(1);
//        }
//        Integer status = pilotProjectFill.getStatus();
//        if(null != status && status == 5){
//            logVo.setFinish(true);
//        }else {
//            logVo.setFinish(false);
//        }
//        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
//        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
//        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
//        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
//        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
//        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
//        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
//        logVo.setOperateDate(LocalDateTime.now());
//        logVo.setApprovalComments(approvalComments);
//        logVo.setModeType(0);
//        logVo.setPriority(0);
//        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
//    }
//
//    /**
//     * 对象转Map
//     *
//     * @param object
//     * @return
//     * @throws IllegalAccessException
//     */
//    public static Map beanToMap(Object object) throws IllegalAccessException {
//        Map<String, Object> map = new HashMap<String, Object>();
//        Field[] fields = object.getClass().getDeclaredFields();
//        for (Field field : fields) {
//            field.setAccessible(true);
//            map.put(field.getName(), field.get(object));
//        }
//        return map;
//    }

//                        .getMunicipalMajorProjectManagement(p.getProjectId());
//                vo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
//                // 根据审核ID查询其他审核信息，项目信息、目标信息 、举措信息、季度计划信息
//                /*
//                PilotProjectFillQueryVo details = getDetails(p.getId());
//                vo.setMunicipalMajorProjectManagement(details.getMunicipalMajorProjectManagement());
//                vo.setPilotQuantitativeObjectivesPushList(details.getPilotQuantitativeObjectivesPushList());
//                vo.setPilotMeasuresPushList(details.getPilotMeasuresPushList());
//                vo.setPilotBrandPushList(details.getPilotBrandPushList());
//                vo.setPilotMeasuresPushList(details.getPilotMeasuresPushList());
//                vo.setPilotExperiencePushList(details.getPilotExperiencePushList());
//
//                 */
//                pilotProjectFillQueryVoList.add(vo);
//            });
//        }
//        PageList<PilotProjectFillQueryVo> result = new PageList<>();
//        result.setRows(pilotProjectFillQueryVoList);
//        result.setPage(pilotProjectFillPageList.getPage());
//        result.setPageSize(pilotProjectFillPageList.getPageSize());
//        result.setTotal(pilotProjectFillPageList.getTotal());
//        return result;
//    }
//
//    @Override
//    public PilotProjectFillQueryVo getDetails(String id) {
//        Assert.notNull(id, "条件格式不能为空");
//        PilotProjectFillQueryVo pilotProjectFillQueryVo = new PilotProjectFillQueryVo();
//        PilotProjectFill pilotProjectFill = this.get(id);
//        pilotProjectFillQueryVo.setPilotProjectFill(pilotProjectFill);
//        if (null != pilotProjectFill) {
//            // 項目信息
//            MunicipalMajorProjectManagement municipalMajorProjectManagement = municipalMajorProjectManagementManager
//                    .getExamineById(pilotProjectFill);
//            pilotProjectFillQueryVo.setMunicipalMajorProjectManagement(municipalMajorProjectManagement);
//
//            // 量化目标推进情况集合（包括目标信息、填报年度信息、填报月度）
//            List<PilotQuantitativeObjectivesPushVo> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectivesPushManager
//                    .queryListByFillId(pilotProjectFill.getId());
//            // 设置对应年度、月度值
//            LocalDate fillDate = pilotProjectFill.getFillDate();
//            if (null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0 && null != fillDate) {
//                pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
//                    List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
//                            .eq("OBJECTIVES_ID_", p.getObjectivesMeasuresId()).eq("YEAR_", fillDate.getYear()));
//                    if (null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0) {
//                        PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetails.get(0);
//                        // 设置年度值
//                        p.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
//                        // 设置月度值
//
//                        try {
//                            Map map = beanToMap(pilotObjectivesDetails1);
//                            Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(fillDate.getMonthValue())));
//                            if (null != o) {
//                                BigDecimal mouthValue = (BigDecimal) o;
//                                p.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
//                            }
//                        } catch (IllegalAccessException e) {
//                            e.printStackTrace();
//                        }
//                    }
//                });
//            }
//            pilotProjectFillQueryVo.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
//            // 项目具体举措计划推进情况集合，包括具体季度的计划
//            List<PilotMeasuresPushVo> pilotMeasuresPushList = pilotMeasuresPushManager.queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotMeasuresPushList(pilotMeasuresPushList);
//            // 按照季度处理季度计划数据
//            List<Map<String, List<PilotMeasuresPushVo>>> pilotSpecificScheduleQuarterList = new ArrayList<>();
//            if (null != pilotMeasuresPushList && pilotMeasuresPushList.size() > 0) {
//                Map<String, List<PilotMeasuresPushVo>> map = new LinkedHashMap<>();
//                for (PilotMeasuresPushVo vo : pilotMeasuresPushList) {
//                    String planQuarter = String.valueOf(vo.getPlanQuarter());
//                    List<PilotMeasuresPushVo> pilotMeasuresPushVos = map.get(planQuarter);
//                    if (null == pilotMeasuresPushVos) {
//                        pilotMeasuresPushVos = new ArrayList<>();
//                        pilotMeasuresPushVos.add(vo);
//                        map.put(planQuarter, pilotMeasuresPushVos);
//                    } else {
//                        pilotMeasuresPushVos.add(vo);
//                        map.put(planQuarter, pilotMeasuresPushVos);
//                    }
//                }
//                if (null != map && map.size() > 0) {
//                    for (String key : map.keySet()) {
//                        Map<String, List<PilotMeasuresPushVo>> subMap = new LinkedHashMap<>();
//                        subMap.put(key, map.get(key));
//                        pilotSpecificScheduleQuarterList.add(subMap);
//                    }
//                }
//            }
//            pilotProjectFillQueryVo.setPilotMeasuresPushQuarterList(pilotSpecificScheduleQuarterList);
//
//            //项目经验推广总结情况集合
//            List<PilotExperiencePush> pilotExperiencePushList = pilotExperiencePushManager.queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotExperiencePushList(pilotExperiencePushList);
//
//            // 进度计划明细推进情况集合
//            List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList = pilotSpecificSchedulePushManager
//                    .queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotSpecificSchedulePushList(pilotSpecificSchedulePushList);
//
//            // 项目品牌显示度情况集合
//            List<PilotBrandPush> pilotBrandPushList = pilotBrandPushManager.queryListByFillId(pilotProjectFill.getId());
//            pilotProjectFillQueryVo.setPilotBrandPushList(pilotBrandPushList);
//        } else {
//            throw new BaseException("未找到相关审核信息");
//        }
//        return pilotProjectFillQueryVo;
//    }

//    @Override
//    public PilotProjectFillQueryVo getHistoryDetails(String projectId) {
//        Assert.notNull(projectId, "项目ID不能为空");
//        // 如果没有传入ID则查询上一次审核通过的记录
//        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("PROJECT_ID_", projectId);
//        queryWrapper.eq("STATUS_", 5);
//        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.orderByDesc("FILL_YEAR_", "FILL_MONTH_", "CREATE_TIME_");
//        queryWrapper.last(" limit 1");
//        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
//        if (null != pilotProjectFill && StringUtils.isNotBlank(pilotProjectFill.getId())) {
//            return this.getDetails(pilotProjectFill.getId());
//        }
//        return new PilotProjectFillQueryVo();
//    }
//
//    @Override
//    public boolean haveExamine(String projectId) {
//        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("PROJECT_ID_", projectId);
//        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.gt("STATUS_", 0);
//        queryWrapper.lt("STATUS_", 5);
//        int count = this.count(queryWrapper);
//        if (count > 0) {
//            return true;
//        }
//        return false;
//    }
//
//    @Override
//    public PilotProjectFillQueryVo getDraftDetails(String projectId) {
//        // 如果没有传入ID则查询上一次审核通过的记录
//        QueryWrapper<PilotProjectFill> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("PROJECT_ID_", projectId);
//        queryWrapper.eq("STATUS_", 0);
//        queryWrapper.eq("IS_DELE_", 0);
//        queryWrapper.orderByDesc("FILL_YEAR_", "FILL_MONTH_, CREATE_TIME_");
//        queryWrapper.last(" limit 1");
//        PilotProjectFill pilotProjectFill = baseMapper.selectOne(queryWrapper);
//        if (null != pilotProjectFill && StringUtils.isNotBlank(pilotProjectFill.getId())) {
//            return this.getDetails(pilotProjectFill.getId());
//        }
//        return null;
//    }

    /**
     * @param pilotProjectFill
     * @param title
     */
    @Override
    public void createLog(PilotProjectFill pilotProjectFill, String title ) {
        List<Integer> statusList = Arrays.asList(0,1, 3, 5);
        // 审批日志
        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(pilotProjectFill.getId());
        logVo.setModeType(2);
        if(pilotProjectFill.getFlowType()==1){
            logVo.setBizType("6-1");
        }else if(pilotProjectFill.getFlowType()==2){
            logVo.setBizType("6-2");
        }else if(pilotProjectFill.getFlowType()==3){
            logVo.setBizType("6-3");
        }else if(pilotProjectFill.getFlowType()==4){
            logVo.setBizType("6-4");
        }

        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");


        // 字典数据 shzt
        logVo.setStatus(String.valueOf(pilotProjectFill.getStatus()));
        logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, pilotProjectFill.getStatus()));

        if (BeanUtils.isNotEmpty(pilotProjectFill.getApprovalResults())&&pilotProjectFill.getApprovalResults()==2){
            if (pilotProjectFill.getStatus()==0){
                logVo.setItemTitle(title +"撤回为草稿" );
                logVo.setOperateInfo("撤回为草稿");
            }else if (pilotProjectFill.getStatus()==1){
                logVo.setItemTitle(title +"撤回为提交待审核" );
                logVo.setOperateInfo("撤回为提交待审核");
            }else if (pilotProjectFill.getStatus()==3){
                logVo.setItemTitle(title +"撤回为审核通过" );
                logVo.setOperateInfo("撤回为审核通过");
            }
            logVo.setApprovalResults(2);
        }else {
            if (null != pilotProjectFill.getStatus() && statusList.contains(pilotProjectFill.getStatus())) {
                logVo.setApprovalResults(0);
            } else {
                logVo.setApprovalResults(1);
            }
            logVo.setItemTitle(title+ BizUtils.getDicValueByCode(shzt, pilotProjectFill.getStatus()));
            logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, pilotProjectFill.getStatus()));
        }
        Integer status = pilotProjectFill.getStatus();
        if(null != status && status == 5){
            logVo.setFinish(true);
        }else {
            logVo.setFinish(false);
        }
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setApprovalComments(pilotProjectFill.getApprovalComments());
        logVo.setModeType(0);
        logVo.setPriority(0);
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    /**
     * 对象转Map
     *
     * @param object
     * @return
     * @throws IllegalAccessException
     */
    public static Map beanToMap(Object object) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<String, Object>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object));
        }
        return map;
    }

//    @Override
//    @Transactional
//    public boolean updateByStatus(PilotProjectFill pilotProjectFill) {
//        boolean res = super.updateById(pilotProjectFill);
//        setApprovalLog(pilotProjectFill.getId(),pilotProjectFill.getStatus(),pilotProjectFill.getApprovalComments());
//        return res;
//    }

//    private void setApprovalLog(String id,Integer status,String approvalComments){
//        // 审批日志
//        PilotProjectFill fill = super.getById(id);
//        MunicipalMajorProjectManagement manager = municipalMajorProjectManagementManager.getById(fill.getProjectId());
//        List<DictModel> shzt = sysDictionaryManager.queryDictListItemsByCode("shzt");
//        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
//        logVo.setBizId(id);
//        logVo.setModeType(1);
//        logVo.setBizType("6-4");
//        logVo.setModuleTableName("BIZ_PILOT_PROJECT_FILL");
//        if (status==1){
//            logVo.setItemTitle("【"+manager.getProjectName()+"】提交待审核");
//        }else if (status==2){
//            logVo.setItemTitle("【"+manager.getProjectName()+"】责任单位领导审核驳回");
//        }else if (status==3){
//            logVo.setItemTitle("【"+manager.getProjectName()+"】责任单位领导审核通过");
//        }else if (status==4){
//            logVo.setItemTitle("【"+manager.getProjectName()+"】市委改革办审核驳回");
//        }else if (status==5){
//            logVo.setItemTitle("【"+manager.getProjectName()+"】市委改革办审核通过");
//        }
//        logVo.setStatus(status.toString());
//        logVo.setOperateInfo(BizUtils.getDicValueByCode(shzt, status));
//        if (status%2==0){
//            logVo.setApprovalResults(1);
//        }else {
//            logVo.setApprovalResults(0);
//        }
//        if (status==2||status==4){
//            logVo.setApprovalComments(approvalComments);
//        }else if (status==1){
//            logVo.setApprovalComments(null);
//        }
//        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
//        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
//        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
//        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
//        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
//        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
//        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
//        logVo.setOperateDate(LocalDateTime.now());
//        logVo.setModeType(0);
//        logVo.setPriority(0);
//        // 保存审批日志
//        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
//    }
}

