package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 专项小组信息信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-05-15
 */
@Data
@TableName("BIZ_SPECIAL_GROUP")
@ApiModel(value="BizSpecialGroup对象", description="专项小组信息信息")
public class BizSpecialGroup extends AutoFillFullModel<BizSpecialGroup> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专项小组类型（1：专题组，2：专项小组）")
    @TableField("GROUP_TYPE_")
    private Integer groupType;

    @ApiModelProperty(value = "专项小组名称")
    @TableField("GROUP_NAME_")
    private String groupName;

    @ApiModelProperty(value = "所属领域（使用字典，1：党建统领，2：经济发展，3：社会民生，4：文化建设，5：平安法治 6：民主法制）")
    @TableField("GROUP_FIELD_")
    private Integer groupField;

    @ApiModelProperty(value = "专项小组单位")
    @TableField(exist = false)
    private List<BizSpecialGroupOrg> bizSpecialGroupOrgList;

    @ApiModelProperty(value = "单位名称")
    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty(value = "单位ID")
    @TableField(exist = false)
    private String orgId;
}
