package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 试点迭代管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-07-13
 */
@TableName("BIZ_REFORM_ITERATE_PILOT_MANAGEMENT")
@ApiModel(value="BizReformIteratePilotManagement对象", description="试点迭代管理表")
@Data
public class BizReformIteratePilotManagement extends AutoFillFullModel<BizReformIteratePilotManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "原始表id")
    @TableField("PILOT_ID_")
    private String pilotId;

    @ApiModelProperty(value = "试点项目名称")
    @TableField("PILOT_PROJECT_NAME_")
    private String pilotProjectName;

    @ApiModelProperty(value = "试点文件字号")
    @TableField("DOC_NAME_")
    private String docName;

    @ApiModelProperty(value = "试点文件年份")
    @TableField("DOC_YEAR_")
    private Integer docYear;

    @ApiModelProperty(value = "试点文件号数")
    @TableField("DOC_NUM_")
    private Integer docNum;

    @ApiModelProperty(value = "试点文件文号")
    @TableField("DOC_NO_")
    private String docNo;

    @ApiModelProperty(value = "文件依据")
    @TableField("DOCUMENT_BASIS_")
    private String documentBasis;

    @ApiModelProperty(value = "试点层级（使用字典，选择国家级时主管部门才显示，否则隐藏，1：国家级，2：市级）")
    @TableField("PILOT_LEVEL_")
    private Integer pilotLevel;

    @ApiModelProperty(value = "主管部委（使用级联字典，与试点层级级联，1：外交部，2：国防部，3：发展改革委，请自行百度搜索全的）")
    @TableField("PILOT_SUPERVISOR_")
    private String pilotSupervisor;

    @ApiModelProperty(value = "时间期限")
    @TableField("TIME_PERIOD_")
    private Integer timePeriod;

    @ApiModelProperty(value = "开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("START_TIME_")
    private Date startTime;

    @ApiModelProperty(value = "验收时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("ACCEPTANCE_TIME_")
    private Date acceptanceTime;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("PILOT_FIELD_")
    private Integer pilotField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("PILOT_RUNWAY_")
    private Integer pilotRunway;

    @ApiModelProperty(value = "试点范围")
    @TableField("PILOT_RANGE_")
    private String pilotRange;

    @ApiModelProperty(value = "试点目标")
    @TableField("PILOT_TARGET_")
    private String pilotTarget;

    @ApiModelProperty(value = "市级牵头单位")
    @TableField("LEAD_UNIT_NAME_")
    private String leadUnitName;

    @ApiModelProperty(value = "专项小组名称")
    @TableField("GROUP_NAME_")
    private String groupName;

    @ApiModelProperty(value = "主要责任单位ID（关联组织机构表ID）")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "主要责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "任务详情")
    @TableField("TASK_DETAILS_")
    private String taskDetails;

    @ApiModelProperty(value = "迭代原因")
    @TableField("ITERATE_CAUSE_")
    private String iterateCause;

    @ApiModelProperty(value = "迭代类型(0.修改 1.删除)")
    @TableField("ITERATE_TYPE_")
    private Integer iterateType;

    @ApiModelProperty(value = "试点类型(区县:0，市级:1)")
    @TableField("PILOT_TYPE_")
    private Integer pilotType;

    @ApiModelProperty(value = "审核状态（审核状态:0:提交改革办核准1.改革办审核驳回 2:改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "改革试点未修改前时间期限")
    @TableField("ITER_TIME_PERIOD_")
    private Integer iterTimePeriod;

    @ApiModelProperty(value = "改革试点未修改前验收时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("ITER_ACCEPTANCE_TIME_")
    private Date iterAcceptanceTime;

    @TableField(exist = false)
    @ApiModelProperty(value = "审批意见")
    private String approvalComments;

    @TableField(exist = false)
    @ApiModelProperty(value = "操作")
    private Integer approvalResults;

    @TableField(exist = false)
    @ApiModelProperty(value = "改革试点审核状态")
    private Integer pilotStatus;

    @ApiModelProperty(value = "涉及区县")
    @TableField(exist = false)
    private List<BizReformIterateInvolvedDistricts> invs;

}
