package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.file.model.DefaultFile;
import com.artfess.poi.reader.DataEntity;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
@TableName("BIZ_PILOT_ADVANCE_RECORD")
@ApiModel(value ="试点项目推进记录")
public class BizPilotAdvanceRecord extends AutoFillFullModel<BizPilotAdvanceRecord> {

        private static final long serialVersionUID = 1L;

        @ApiModelProperty(value = "主键_ID")
        @TableId(value = "ID_", type = IdType.ASSIGN_ID)
        private String id;

        @ApiModelProperty(value = "试点ID（关联各个试点主表）")
        @TableField("PILOT_ID_")
        private String pilotId;

        @ApiModelProperty(value = "推进状态（使用字典：2：推进中，3：已验收）")
        @TableField("PROPULSIVE_STATUS_")
        private Integer propulsiveStatus;

        @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
        @ApiModelProperty(value = "实际验收时间")
        @TableField("ACTUAL_TIME_")
        private Date actualTime;

        @ApiModelProperty(value = "下一步工作计划")
        @TableField("WORK_PLAN_")
        private String workPlan;

        @ApiModelProperty(value = "存在问题")
        @TableField("EXISTING_PROBLEMS_")
        private String existingProblems;

        @ApiModelProperty(value = "已开展工作")
        @TableField("PROPULSIVE_DETAILS_")
        private String propulsiveDetails;

        @ApiModelProperty(value = "涉及区县单位ID（（关联组织机构表ID））")
        @TableField("UNIT_ID_")
        private String unitId;

        @ApiModelProperty(value = "涉及区县单位NAME（关联组织机构表NAME）")
        @TableField("UNIT_NAME_")
        private String unitName;

        @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
        @TableField("UNIT_CODE_")
        private String unitCode;

        @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
        @TableField("UNIT_GRADE_")
        private String unitGrade;

        @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待审核，2：主管部门领导确认驳回，3：主管部门领导确认通过【区县待更新】 ， 4：区县领导确认驳回 ， 5：区县领导确认通过【试点主管部门待审核】。6：试点主管部门审核驳回。7：试点主管部门审核通过【改革办待审核】。8：市委改革办审核驳回。9：市委改革办审核通过）")
        @TableField("STATUS_")
        private Integer status;

        @TableLogic
        @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
        @TableField("IS_DELE_")
        private String isDele="0";

        @ApiModelProperty(value = "是否涉密")
        @TableField("CLASSIFIED_")
        private Integer classified;

        @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
        @TableField(exist = false)
        private Date hisDate;


        @TableField(exist = false)
        @ApiModelProperty(value = "附件集合")
        List<String> ids;


        @TableField(exist = false)
        @ApiModelProperty(value = "附件对象集合")
        List<DefaultFile> fileList;


        @TableField(exist = false)
        @ApiModelProperty(value = "推进记录成果对象集合")
        List<BizPilotAdvanceResult> results;

        @ApiModelProperty(value = "审批意见")
        @TableField(exist = false)
        private String approvalComments;

        @ApiModelProperty(value = "操作用户")
        @TableField(exist = false)
        private String operateUser;

        @ApiModelProperty(value = "操作时间")
        @TableField(exist = false)
        private LocalDateTime operateTime;
    }

