package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizPilotAdvanceCityRecord;
import com.artfess.reform.fill.model.BizReformPilotCityManagement;
import com.artfess.reform.fill.model.BizReformPilotManagement;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface BizReformPilotCityManagementManager extends BaseManager<BizReformPilotCityManagement> {
    /**
     * 市级试点迭代验收时间
     * @param bizReformPilotManagement
     * @return
     */
    String updateIterateInfo(BizReformPilotCityManagement bizReformPilotManagement);

    /**
     * 保存或者修改信息
     * @param bizReformPilotCityManagement
     * @return
     */
    boolean saveOrUpdateInfo(BizReformPilotCityManagement bizReformPilotCityManagement);

    /**
     * 是否存在相同文号
     * @param id,docNo
     * @return
     */
    boolean  isSameExists(String id,String docNo);

    /**
     * 删除数据
     * @param ids
     * @return
     */
    void deleteInfo(String ids,boolean isAffirm);

    /**
     * 修改审核状态
     * @param entity
     * @return
     */
    boolean updateByStatus(BizPilotAdvanceCityRecord entity);

    /**
     * 市级部门,改革办分页查询
     * @param queryFilter
     * @param isAffirm
     * @return
     */
    PageList<BizReformPilotCityManagement> queryPage(QueryFilter<BizReformPilotCityManagement> queryFilter,boolean isAffirm);

    /**
     * 专项小组分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizReformPilotCityManagement> queryGroupPage(QueryFilter<BizReformPilotCityManagement> queryFilter);

    /**
     * 导出接口
     * @param response
     * @param queryFilter
     * @throws Exception
     */
     void  pilotExport(HttpServletResponse response, QueryFilter<BizReformPilotCityManagement> queryFilter ) throws Exception;

}
