package com.artfess.reform.fill.manager;

import com.artfess.reform.fill.model.BizBlockageCardTransferRecord;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;

/**
 * 堵点卡点交办推进记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
public interface BizBlockageCardTransferRecordManager extends BaseManager<BizBlockageCardTransferRecord> {

    /**
     * @param record
     * @Description: 保存堵点卡点推进记录
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 17:25
     */
    String insertInfo(BizBlockageCardTransferRecord record);

    /**
     * @param record
     * @Description: 修改
     * @Author: chens
     * @Date: 2023/3/22 17:43
     */
    void updateInfo(BizBlockageCardTransferRecord record);

    /**
     * @param record 推进记录表
     * @Description: 修改审核状态
     * @Return: java.lang.String
     * @Author: chens
     * @Date: 2023/3/22 10:21
     */
    void updateAuditStatus(BizBlockageCardTransferRecord record);

}
