package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.poi.util.ExcelUtils;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 满意度区县结果表 前端控制器
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-20
 */
@RestController
@RequestMapping("/biz/reformSatisfaction/districts/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "满意度区县结果")
public class BizReformSatisfactionDistrictsController extends BaseController<BizReformSatisfactionDistrictsManager, BizReformSatisfactionDistricts> {

    @PutMapping("/batchUpdate")
    @ApiOperation("批量更新实体")
    public CommonResult<String> batchUpdate(@ApiParam(name = "model", value = "实体信息") @RequestBody BizReformSatisfactionManagement t) {
        boolean result = baseService.batchUpdate(t);
        if (!result) {
            return new CommonResult<String>(false, null);
        }
        return new CommonResult<String>(true, null);
    }

    /**
     * @param file
     * @param satisfactionId
     * @return
     */
    @ApiOperation(value = "满意度区县结果表数据导入")
    @PostMapping("/importExcel")
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file, @RequestParam(value = "satisfactionId", required = true) String satisfactionId) {
        try {
            ExcelUtils<BizReformSatisfactionDistricts> excelUtil = new ExcelUtils<>(BizReformSatisfactionDistricts.class);
            List<BizReformSatisfactionDistricts> list = excelUtil.importExcel(null, file.getInputStream(), 6);
            boolean result = baseService.importExcel(list, satisfactionId);
            if (!result) {
                throw new IllegalArgumentException("导入失败");
            }
            return new CommonResult<>();
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("导入失败，" + e.getMessage());
        }
    }

    @PostMapping(value = "/detailQuery", produces = {"application/json; charset=utf-8"})
    @ApiOperation("获取详情数据")
    public CommonResult detailQuery(@RequestParam(value = "satisfactionId", required = true) String satisfactionId) {
        List<BizReformSatisfactionDistricts> list = baseService.queryBySatisfactionId(satisfactionId);
        return CommonResult.success(list, null);
    }


    /**
     * @param
     * @param satisfactionId
     * @return
     */
    @ApiOperation(value = "满意度区县结果表数据导出")
    @PostMapping("/exportExcel")
    public void exportExcel(HttpServletResponse response,@RequestParam(value = "satisfactionId", required = true) String satisfactionId) {
        try {
            List<BizReformSatisfactionDistricts> entity = baseService.queryBySatisfactionId(satisfactionId);
            List<Map<String, Object> > list = new ArrayList<>();
            if(BeanUtils.isNotEmpty(entity)){
                for (BizReformSatisfactionDistricts e : entity) {
                    String jsonStr = JsonUtil.toJson(e);
                    Map<String, Object> map = JsonUtil.toMap(jsonStr);
                    list.add(map);
                }
            }
            String tempName = "区县改革满意度评价表";
            Map<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("unitCode", "区县编码");
            exportMaps.put("unitName", "区县");
            exportMaps.put("satisfaction", "综合评价得分");
            exportMaps.put("ecoField", "经济社会发展领域评价得分（40%）");
            exportMaps.put("ecoZs", "招商引资成效评价得分");
            exportMaps.put("ecoCy", "就业创业环境评价得分");
            exportMaps.put("ecoYl", "医疗卫生服务评价得分");
            exportMaps.put("ecoJy", "教育环境评价得分");
            exportMaps.put("ecoSt", "生态环境评价得分");
            exportMaps.put("demField", "民主政治领域评价得分（15%）");
            exportMaps.put("demYs", "民主议事开展评价得分");
            exportMaps.put("demBs", "办事效率评价得分");
            exportMaps.put("culField", "文化领域评价得分（15%）");
            exportMaps.put("culWh", "文化、体育、艺术活动评价得分");
            exportMaps.put("culAg", "爱国主义教育成效评价得分");
            exportMaps.put("peaceField", "平安法治领域评价得分（15%）");
            exportMaps.put("peaceSf", "司法机关公正司法评价得分");
            exportMaps.put("peaceZa", "社会治安状况评价得分");
            exportMaps.put("partyField", "党建统领领域评价得分（15%）");
            exportMaps.put("partyGb", "党政领导机关干部干事劲头和精神状态评价得分");
            exportMaps.put("partyQl", "党员干部清廉从政评价得分");
            exportMaps.put("regionSn", "综合得分区域排名");
            exportMaps.put("allSn", "综合得分全市排名");
            HSSFWorkbook book = ExcelUtil.exportTemplateExcel(tempName, exportMaps, list,3,"excel/satisfaction.xls");
            ExcelUtil.downloadExcel(book, tempName, response);
        } catch (Exception e) {
            throw new RuntimeException("导出失败：" + e.getMessage());
        }
    }

}
