package com.artfess.reform.statistics.model;

import com.artfess.reform.fill.vo.IterationAddVO;
import com.artfess.reform.fill.vo.IterationUpdateVO;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目具体举措迭代统计表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-15
 */
@TableName("BIZ_SCORING_PROJECT_ITERATION")
@ApiModel(value="BizScoringProjectIteration对象", description="项目具体举措迭代统计表")
@Data
public class BizScoringProjectIteration extends BaseModel<BizScoringProjectIteration> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评比日期")
    @TableField("FILL_DATE_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "评比年")
    @TableField("FILL_YEAR_")
    private Integer fillYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("FILL_QUARTER_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("FILL_MONTH_")
    private Integer fillMonth;

    @ApiModelProperty(value = "评比类型")
    @TableField("FILL_TYPE_")
    private String fillType;

    @ApiModelProperty(value = "评比项目")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "评比项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目迭代举措次数")
    @TableField("UPDATE_NUM_")
    private Integer updateNum;

    @ApiModelProperty(value = "项目新增举措次数")
    @TableField("ADD_NUM_")
    private Integer addNum;

    @ApiModelProperty(value = "项目举措总的总迭代次数")
    @TableField("ITERATION_NUM_")
    private Integer iterationNum;

    @ApiModelProperty(value = "项目迭代排名")
    @TableField("ITERATION_SN_")
    private Integer iterationSn;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private Long lastTime;

    @ApiModelProperty("迭代集合")
    @TableField(exist = false)
    private List<IterationUpdateVO> updateVOS;

    @ApiModelProperty("新增集合")
    @TableField(exist = false)
    private List<IterationAddVO> addVOS;

}
