package com.artfess.reform.majorProjects.vo;

import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 改革方案明确的量化目标表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@ApiModel(value="PilotSpecificSchedulePushAndMeasurePushVo对象", description="项目改革方案明确的计划推进情况及其他改革成果参数VO")
public class PilotSpecificSchedulePushAndMeasurePushVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "填报信息对象")
    private PilotProjectFill pilotProjectFill;

    @ApiModelProperty(value = "其他改革成果（明细推进情况集合）")
    private List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList;

    @ApiModelProperty(value = "项目改革方案明确的计划推进情况集合")
    private List<PilotMeasuresPush> pilotMeasuresPushList;

}
