package com.artfess.reform.majorProjects.vo;

import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotSpecificSchedulePush;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
@ApiModel(value="PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo对象", description="市级重大改革项目改革方案明确的月度计划推进详情及其他改革成果审核记录查询详情")
public class PilotSpecificSchedulePushAndMeasurePushFillQueryDetailVo {

    @ApiModelProperty(value = "市级重大改革项目信息")
    private MunicipalMajorProjectManagement municipalMajorProjectManagement;

    @ApiModelProperty(value = "市级重大改革项目填报审核记录")
    private PilotProjectFill pilotProjectFill;

    @ApiModelProperty(value = "市级重大改革项目填报审核记录历史")
    private PilotProjectFill pilotProjectFillHistory;


    @ApiModelProperty(value = "历史-其他改革成果（进度计划明细推进情况）集合")
    private List<PilotSpecificSchedulePush> pilotSpecificSchedulePushHistoryList;

    @ApiModelProperty(value = "历史-改革方案明确的月度计划推进详情包括月度计划信息集合")
    private List<PilotMeasuresPushVo> pilotMeasuresPushHistoryList;

    @ApiModelProperty(value = "历史-改革方案明确的月度计划推进详情包括月度计划信息集合（按照季度处理后的数据）")
    private List<Map<String, List<PilotMeasuresPushVo>>> pilotMeasuresPushQuarterHistoryList;



    @ApiModelProperty(value = "其他改革成果（进度计划明细推进情况）集合")
    private List<PilotSpecificSchedulePush> pilotSpecificSchedulePushList;

    @ApiModelProperty(value = "改革方案明确的月度计划推进详情包括月度计划信息集合")
    private List<PilotMeasuresPushVo> pilotMeasuresPushList;

    @ApiModelProperty(value = "改革方案明确的月度计划推进详情包括月度计划信息集合（按照季度处理后的数据）")
    private List<Map<String, List<PilotMeasuresPushVo>>> pilotMeasuresPushQuarterList;

}
