package com.artfess.reform.majorProjects.model;

import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革方案明确的量化目标的计划值
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-11
 */
@Data
@ApiModel(value="BizPilotObjectivesDetails对象", description="改革方案明确的量化目标的计划值")
@TableName("BIZ_PILOT_OBJECTIVES_DETAILS")
public class PilotObjectivesDetails extends BaseModel<PilotObjectivesDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "重大项目ID（关联市级重大改革项目管理表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "目标ID")
    @TableField("OBJECTIVES_ID_")
    private String objectivesId;

    @ApiModelProperty(value = "年度")
    @TableField("YEAR_")
    private Integer year;

    @ApiModelProperty(value = "目标值")
    @TableField("YEAR_VALUE_")
    private BigDecimal yearValue;

    @ApiModelProperty(value = "1月目标值")
    @TableField("JAN_VALUE_")
    private BigDecimal janValue;

    @ApiModelProperty(value = "2月目标值")
    @TableField("FEB_VALUE_")
    private BigDecimal febValue;

    @ApiModelProperty(value = "3月目标值")
    @TableField("MAR_VALUE_")
    private BigDecimal marValue;

    @ApiModelProperty(value = "4月目标值")
    @TableField("APR_VALUE_")
    private BigDecimal aprValue;

    @ApiModelProperty(value = "5月目标值")
    @TableField("MAY_VALUE_")
    private BigDecimal mayValue;

    @ApiModelProperty(value = "6月目标值")
    @TableField("JUN_VALUE_")
    private BigDecimal junValue;

    @ApiModelProperty(value = "7月目标值")
    @TableField("JUL_VALUE_")
    private BigDecimal julValue;

    @ApiModelProperty(value = "8月目标值")
    @TableField("AUG_VALUE_")
    private BigDecimal augValue;

    @ApiModelProperty(value = "9月目标值")
    @TableField("SEP_VALUE_")
    private BigDecimal sepValue;

    @ApiModelProperty(value = "10月目标值")
    @TableField("OCT_VALUE_")
    private BigDecimal octValue;

    @ApiModelProperty(value = "11月目标值")
    @TableField("NOV_VALUE_")
    private BigDecimal novValue;

    @ApiModelProperty(value = "12月目标值")
    @TableField("DEC_VALUE_")
    private BigDecimal decValue;

//    @ApiModelProperty(value = "最后更新时间戳")
//    @TableField("LAST_TIME_")
//    private Long lastTime;

    @ApiModelProperty(value = "最后更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill=FieldFill.INSERT_UPDATE, select=true)
    private Long lastTime;

}
