package com.artfess.reform.majorProjects.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.base.typehandle.StringConvert2IntHandler;
import com.baomidou.mybatisplus.annotation.*;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 市级重大改革项目管理表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@TableName("BIZ_MUNICIPAL_MAJOR_PROJECT_MANAGEMENT")
@ApiModel(value="BizMunicipalMajorProjectManagement对象", description="市级重大改革项目管理表")
public class MunicipalMajorProjectManagement extends AutoFillFullModel<MunicipalMajorProjectManagement>{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目类型(1:加快实施一批，2:准备启动一批，3:谋划储备一批)")
    @TableField("PROJECT_TYPE_")
    private Integer projectType;

    @ApiModelProperty(value = "牵头市领导")
    @TableField("LEADER_")
    private String leader;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    @TableField("PROJECT_FIELD_")
    private Integer projectField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    @TableField("PROJECT_RUNWAY_")
    private Integer projectRunway;
    
    @ApiModelProperty(value = "项目开始日期")
    @TableField("START_DATE_")
    private LocalDate startDate;

    @ApiModelProperty(value = "项目结项日期")
    @TableField("END_DATE_")
    private LocalDate endDate;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "结项时间")
    @TableField("CLOSING_TIME_")
    private LocalDateTime closingTime;

    @ApiModelProperty(value = "是否结项（0：已结项，1：未结项，结项后数据将不再在驾驶舱上面展示）")
    @TableField("CLOSING_")
    private Integer closing;

    @ApiModelProperty(value = "审核状态（-1：待更新  0：草稿，1：已录入待审核，2：责任单位领导审核驳回，3：责任单位领导审核通过，4：市委改革办审核驳回，5：市委改革办审核通过）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "下发状态（ 0：未下发，1：已下发）")
    @TableField("SEND_STATUS_")
    private Integer sendStatus;

    @ApiModelProperty(value = "下发时间")
    @TableField("SEND_TIME_")
    private LocalDateTime sendTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @TableField(value = "IS_DELE_",typeHandler = StringConvert2IntHandler.class)
    @ApiModelProperty(name="isDele",notes="是否已删除 0：未删除 1：已删除（新增、更新数据时不需要传入）")
    private String isDele = "0";

    @ApiModelProperty(value = "改革方案明确的量化目标集合")
    @TableField(exist = false)
    private List<PilotQuantitativeObjectives> pilotQuantitativeObjectivesList;

    @ApiModelProperty(value = "改革方案明确的具体举措集合")
    @TableField(exist = false)
    private List<PilotSpecificMeasures> pilotSpecificMeasuresList;

    @ApiModelProperty(value = "进度计划表集合")
    @TableField(exist = false)
    private List<PilotSpecificSchedule> pilotSpecificScheduleList;


    @ApiModelProperty(value = "进度计划表集合（按照季度处理后的数据）")
    @TableField(exist = false)
    private List<Map<String, List<PilotSpecificSchedule>>> pilotSpecificScheduleQuarterList;

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "执行结果（0：同意，1：驳回，2：撤回）")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "本次更新时间")
    @TableField(exist = false)
    private LocalDate thisTime;


}
