package com.artfess.reform.majorProjects.manager.impl;

import com.artfess.reform.majorProjects.manager.PilotObjectivesDetailsManager;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesPushManager;
import com.artfess.reform.majorProjects.model.MouthFieldEnum;
import com.artfess.reform.majorProjects.model.PilotObjectivesDetails;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectives;
import com.artfess.reform.majorProjects.dao.PilotQuantitativeObjectivesDao;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 改革方案明确的量化目标表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Service
public class PilotQuantitativeObjectivesManagerImpl extends BaseManagerImpl<PilotQuantitativeObjectivesDao, PilotQuantitativeObjectives> implements PilotQuantitativeObjectivesManager {

    @Resource
    private PilotQuantitativeObjectivesPushManager pilotQuantitativeObjectivesPushManager;

    @Resource
    private PilotObjectivesDetailsManager pilotObjectivesDetailsManager;

    public void removeByProjectId(String projectId){
        // 删除主表信息
        super.remove(new QueryWrapper<PilotQuantitativeObjectives>().eq("PROJECT_ID_", projectId));
        // 删除子表信息
        pilotQuantitativeObjectivesPushManager.remove(new QueryWrapper<PilotQuantitativeObjectivesPush>()
                .eq("PROJECT_ID_", projectId));
    }

    @Override
    public boolean saveBatch(List<PilotQuantitativeObjectives> entityList) {
        // 保存主表
        boolean b = super.saveBatch(entityList);
        // 保存推进情况
        for (PilotQuantitativeObjectives pilotQuantitativeObjectives : entityList){
            List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectives
                    .getPilotQuantitativeObjectivesPushList();
            if(null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0){
                pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                    // 设置项目明确目标ID
                    p.setObjectivesMeasuresId(pilotQuantitativeObjectives.getId());
                    // 设置项目ID
                    p.setProjectId(pilotQuantitativeObjectives.getProjectId());
                    p.setLastTime(new Date().getTime());
                });
                pilotQuantitativeObjectivesPushManager.saveBatch(pilotQuantitativeObjectivesPushList);
            }
        }
        return b;
    }

    @Override
    public boolean saveOrUpdate(PilotQuantitativeObjectives pilotQuantitativeObjectives) {
        boolean b = super.saveOrUpdate(pilotQuantitativeObjectives);
        List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectives
                .getPilotQuantitativeObjectivesPushList();
        if(null != pilotQuantitativeObjectivesPushList && pilotQuantitativeObjectivesPushList.size() > 0){
            pilotQuantitativeObjectivesPushList.stream().forEach(p -> {
                // 设置项目明确目标ID
                p.setObjectivesMeasuresId(pilotQuantitativeObjectives.getId());
                // 设置项目ID
                p.setProjectId(pilotQuantitativeObjectives.getProjectId());
                p.setLastTime(new Date().getTime());
            });
            pilotQuantitativeObjectivesPushManager.saveOrUpdateBatch(pilotQuantitativeObjectivesPushList);
        }
        return b;
    }

    @Override
    public List<PilotQuantitativeObjectives> queryListByProjectId(String projectId) {
        List<PilotQuantitativeObjectives> list = super.list(new QueryWrapper<PilotQuantitativeObjectives>()
                .eq("PROJECT_ID_", projectId).eq("IS_DELE_", "0"));
        if (null != list && list.size() > 0){
            for(PilotQuantitativeObjectives pilotQuantitativeObjectives : list){
                List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectivesPushManager
                        .list(new QueryWrapper<PilotQuantitativeObjectivesPush>()
                        .eq("OBJECTIVES_MEASURES_ID_", pilotQuantitativeObjectives.getId()).eq("IS_DELE_", "0"));
                pilotQuantitativeObjectives.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
                List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
                        .eq("OBJECTIVES_ID_", pilotQuantitativeObjectives.getId()));
                pilotQuantitativeObjectives.setPilotObjectivesDetailsList(pilotObjectivesDetails);
            }
        }
        return list;
    }

    @Override
    public List<PilotQuantitativeObjectives> queryPilotQuantitativeObjectivesListByProjectId(String projectId) {
        List<PilotQuantitativeObjectives> list = super.list(new QueryWrapper<PilotQuantitativeObjectives>()
                .eq("PROJECT_ID_", projectId).eq("IS_DELE_", "0"));
        if(null != list && list.size() > 0){
            for (PilotQuantitativeObjectives pilotQuantitativeObjectives : list){
                List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
                        .eq("OBJECTIVES_ID_", pilotQuantitativeObjectives.getId()));
                pilotQuantitativeObjectives.setPilotObjectivesDetailsList(pilotObjectivesDetails);
            }
        }
        return list;
    }



    /**
     * 根据项目ID查询目标集合，同时会把最新当前年度目标值，当前月度目标值查询出来放在每一条的目标上
     * @param projectId
     * @param fillDate
     * @return
     */
    @Override
    public List<PilotQuantitativeObjectives> queryListByProjectId(String projectId, LocalDate fillDate) {
        if(null == fillDate){
            fillDate = LocalDate.now();
        }
        List<PilotQuantitativeObjectives> list = super.list(new QueryWrapper<PilotQuantitativeObjectives>()
                .eq("PROJECT_ID_", projectId).eq("IS_DELE_", "0"));
        if (null != list && list.size() > 0){
            for(PilotQuantitativeObjectives pilotQuantitativeObjectives : list){
//                List<PilotQuantitativeObjectivesPush> pilotQuantitativeObjectivesPushList = pilotQuantitativeObjectivesPushManager
//                        .list(new QueryWrapper<PilotQuantitativeObjectivesPush>()
//                                .eq("OBJECTIVES_MEASURES_ID_", pilotQuantitativeObjectives.getId()).eq("IS_DELE_", "0"));
//                pilotQuantitativeObjectives.setPilotQuantitativeObjectivesPushList(pilotQuantitativeObjectivesPushList);
                List<PilotObjectivesDetails> pilotObjectivesDetails = pilotObjectivesDetailsManager.list(new QueryWrapper<PilotObjectivesDetails>()
                        .eq("OBJECTIVES_ID_", pilotQuantitativeObjectives.getId()).eq("YEAR_", fillDate.getYear()));
                pilotQuantitativeObjectives.setPilotObjectivesDetailsList(pilotObjectivesDetails);
                if(null != pilotObjectivesDetails && pilotObjectivesDetails.size() > 0){
                    PilotObjectivesDetails pilotObjectivesDetails1 = pilotObjectivesDetails.get(0);
                    pilotQuantitativeObjectives.setReformQuantitativeObjectivesYear(pilotObjectivesDetails1.getYearValue().toPlainString());
                    try {
                        Map map = beanToMap(pilotObjectivesDetails1);
                        Object o = map.get(MouthFieldEnum.getDescByCode(String.valueOf(fillDate.getMonthValue())));
                        if(null != o){
                            BigDecimal mouthValue = (BigDecimal) o;
                            pilotQuantitativeObjectives.setReformQuantitativeObjectivesMouth(mouthValue.toPlainString());
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    /**
     * 对象转Map
     * @param object
     * @return
     * @throws IllegalAccessException
     */
    public static Map beanToMap(Object object) throws IllegalAccessException {
        Map<String, Object> map = new HashMap<String, Object>();
        Field[] fields = object.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(object));
        }
        return map;
    }
}
