package com.artfess.reform.majorProjects.manager;

import com.artfess.reform.majorProjects.model.PilotBrandPush;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotProjectFillCreateVo;

import java.util.List;

/**
 * 项目品牌显示度情况 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
public interface PilotBrandPushManager extends BaseManager<PilotBrandPush> {
    /**
     * 根据填报ID查询推进信息
     * @param id 填报ID
     * @return
     */
    List<PilotBrandPush> queryListByFillId(String id);

    /**
     * 添加实体类
     * @param pilotProjectFillCreateVo
     */
    void insertInfo(PilotProjectFillCreateVo pilotProjectFillCreateVo);

    /**
     * 修改实体类
     * @param pilotProjectFillCreateVo
     */
    void updateInfo(PilotProjectFillCreateVo pilotProjectFillCreateVo);

    /**
     * 修改审核状态
     * @param pilotProjectFill
     * @return
     */
    boolean updateByStatus(PilotProjectFill pilotProjectFill);

    /**
     * 查询当前记录和历史记录
     * @param id
     * @return
     */
    List<PilotProjectFill> findByHis(String id);

    /**
     *
     * @param id
     * @return
     */
    PilotProjectFill findById(String projectId,Integer year,Integer month);
}
