package com.artfess.reform.fill.vo;

import com.artfess.file.model.DefaultFile;
import com.artfess.reform.fill.model.BizPilotAdvanceRecord;
import com.artfess.reform.fill.model.BizReformInvolvedDistricts;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
@Data
public class InvVO {
    @ApiModelProperty(value = "主键_ID")
    private String id;
    @ApiModelProperty(value = "试点项目文号")
    private String docNo;
    @ApiModelProperty(value = "试点项目名称")
    private String pilotProjectName;
    @ApiModelProperty(value = "试点层级（使用字典，1：国家级，2：市级）")
    private Integer pilotLevel;
    @ApiModelProperty(value = "所属领域")
    private Integer pilotField;
    @ApiModelProperty(value = "所属跑道")
    private Integer pilotRunway;
    @ApiModelProperty(value = "主管部委（使用级联字典，与试点层级级联，1：外交部，2：国防部，3：发展改革委，请自行百度搜索全的）")
    private Integer pilotSupervisor;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "开始时间")
    private Date startTime;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "验收时间")
    private Date acceptanceTime;
    @ApiModelProperty(value = "试点目标")
    private String pilotTarget;
    @ApiModelProperty(value = "任务详情")
    private String taskDetails;
    @ApiModelProperty(value = "审核状态（审核状态（0：草稿，1：已录入待审核，2：主管部门领导确认驳回，3：主管部门领导确认通过【区县待更新】，4：区县已更新，5：已完成，子表更新为已完成时自动更新为已完成）")
    private Integer  status;
    @ApiModelProperty(value = "填报组织名称")
    private String createOrgName;
    @ApiModelProperty(value ="项目推进记录表状态")
    private Integer  recordsStatus;
    @ApiModelProperty(value ="是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    private Integer  classified;
    @ApiModelProperty(value = "区县名称")
    private String unitName;
    @ApiModelProperty(value = "区县id")
    private String unitId;
    @ApiModelProperty(value = "区县grade")
    private String unitGrade;
    @ApiModelProperty(value = "区县code")
    private String unitCode;
    @ApiModelProperty(value = "区县名称")
    private String recId;
    @ApiModelProperty(value = "主要责任单位ID（关联组织机构表ID）")
    private String mainUnitId;
    @ApiModelProperty(value = "主要责任单位NAME（关联组织机构表名称）")
    private String  mainUnitName;
    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    private String  mainUnitCode;
    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    private String  mainUnitGrade;
    @ApiModelProperty(value = "试点项目字号")
    private String docName;
    @ApiModelProperty(value = "试点项目年份")
    private Integer docYear;
    @ApiModelProperty(value = "试点项目号数")
    private Integer docNum;
    @ApiModelProperty(value = "时间期限0：长期,1:限时")
    private Integer timePeriod;
    @ApiModelProperty(value = "文件依据")
    private String documentBasis;
    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "操作日期")
    private LocalDate auditTime;
    @ApiModelProperty(value = "操作人员")
    private String auditUserName;
    @ApiModelProperty(value = "已开展工作")
    private String workPlan;
    @ApiModelProperty(value = "存在问题")
    private String existingProblems;
    @ApiModelProperty(value = "下一步工作计划")
    private String propulsiveDetails;
    @ApiModelProperty(value = "成果推进历史记录")
    private List<BizPilotAdvanceRecord> recordList;
    @ApiModelProperty(value = "审批意见")
    private String approvalComments;
    @ApiModelProperty(value ="涉及区县表")
    List<BizReformInvolvedDistricts> invs;
    @ApiModelProperty(value ="项目推进记录表")
    BizPilotAdvanceRecord bizPilotAdvanceRecords;
    @ApiModelProperty(value ="附件id集合")
    private List<String>  ids;
    @ApiModelProperty(value ="附件id集合")
    private List<DefaultFile>  files;
    @ApiModelProperty(value = "推进状态")
    private Integer propulsiveStatus;
    @ApiModelProperty(value = "是否删除")
    private String isDele;
}
