package com.artfess.reform.fill.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革试点涉及区县表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-07-13
 */
@TableName("BIZ_REFORM_ITERATE_INVOLVED_DISTRICTS")
@ApiModel(value="BizReformIterateInvolvedDistricts对象", description="改革试点涉及区县表")
@Data
public class BizReformIterateInvolvedDistricts extends BaseModel<BizReformIterateInvolvedDistricts> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目ID")
    @TableField("PILOT_ID_")
    private String pilotId;

    @ApiModelProperty(value = "涉及区县单位ID（（关联组织机构表ID））")
    @TableField("UNIT_ID_")
    private String unitId;

    @ApiModelProperty(value = "涉及区县单位NAME（关联组织机构表NAME）")
    @TableField("UNIT_NAME_")
    private String unitName;

    @ApiModelProperty(value = "主要责任单位CODE（关联组织机构表编码）")
    @TableField("UNIT_CODE_")
    private String unitCode;

    @ApiModelProperty(value = "主要责任单位GRADE（关联组织机构表级别）")
    @TableField("UNIT_GRADE_")
    private String unitGrade;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId="1";
}
