package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import java.math.BigInteger;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 改革试点市级部门推进记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-06-15
 */
@TableName("BIZ_PILOT_ADVANCE_CITY_RECORD")
@ApiModel(value="BizPilotAdvanceCityRecord对象", description="改革试点市级部门推进记录表")
@Data
public class BizPilotAdvanceCityRecord extends AutoFillFullModel<BizPilotAdvanceCityRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试点ID（关联各个试点主表）")
    @TableField("PILOT_ID_")
    private String pilotId;

    @ApiModelProperty(value = "推进状态（使用字典：2：推进中，3：已验收）")
    @TableField("PROPULSIVE_STATUS_")
    private Integer propulsiveStatus;

    @ApiModelProperty(value = "实际验收日期")
    @TableField("ACTUAL_TIME_")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualTime;

    @ApiModelProperty(value = "下一步工作计划")
    @TableField("WORK_PLAN_")
    private String workPlan;

    @ApiModelProperty(value = "存在问题")
    @TableField("EXISTING_PROBLEMS_")
    private String existingProblems;

    @ApiModelProperty(value = "推进详情")
    @TableField("PROPULSIVE_DETAILS_")
    private String propulsiveDetails;

    @ApiModelProperty(value = "是否涉密")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "审核状态（0: 草稿，5：主管部门分发，6: 提交待审核，7: 区县驳回，8: 区县通过，9: 主管部门驳回，10: 主管部门通过，11: 改革办驳回 12: 改革办通过）")
    @TableField("STATUS_")
    private Integer status;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "推进信息验收材料")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "驳回意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "操作流程 0.审核通过 1.审核驳回 2.撤回操作")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "试点成果信息表")
    @TableField(exist = false)
    private List<BizPilotAdvanceCityResult> results;
}
