package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 成效晾晒比拼具体情形表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-08
 */
@TableName("BIZ_EFFECT_EFFECTIVENESS")
@ApiModel(value="BizEffectEffectiveness对象", description="成效晾晒比拼具体情形表")
@Data
public class BizEffectEffectiveness extends AutoFillFullModel<BizEffectEffectiveness> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "成效晾晒比拼表ID（关联成效晾晒比拼表ID）")
    @TableField("EFFECT_ID_")
    private String effectId;

    @ApiModelProperty(value = "评比年")
    @TableField("COMPLETION_YEAR_")
    private Integer completionYear;

    @ApiModelProperty(value = "评比季度")
    @TableField("COMPLETION_QUARTER_")
    private Integer completionQuarter;

    @ApiModelProperty(value = "评比月")
    @TableField("COMPLETION_MONTH_")
    private Integer completionMonth;

    @ApiModelProperty(value = "成效日期")
    @TableField("COMPLETION_DATE_")
    private LocalDate completionDate;

    @ApiModelProperty(value = "成效形式（使用字典，1：获全国性肯定评价，2：获全市推广，3：被5家中央媒体深度专题报道）")
    @TableField("EFFECT_FORM_")
    private Integer effectForm;

    @ApiModelProperty(value = "具体情形（使用级联字典，与成效形式级联，获全国性肯定评价包括: 1：在党和国家领导人出席的全国性会议作经验交流，2：获党中央国务院或中办国办发文通报表彰。3：在党中央国务院或中办国办文件中得到肯定性表述。4：被中央和国家有关部委工作简报刊发。5：获党和国家领导人肯定性批示。6：在国家部委主要领导出席的全国性会议作经验交流。7：在国家部委文件中得到肯定性表述。	            获全市推广包括:	            1：获市委市政府(含两办)文件点名推广。2：在有市委或市政府主要领导出席的全市性会议上作经验交流。3：在本区县召开有市领导参加的改革经验现场推广会。4：改革经验被列入市委:“最佳实践”案例。5：在本区县召开有市级部门主要负责人参加的全市性改革经验现场推广会。6：获市级部门文件点名推广。	            5家中央媒体包括: 1：人民日报新华社。2：光明日报。3：经济日报。4：中央广播电视总台）")
    @TableField("SPECIFIC_DETAILS_")
    private Integer specificDetails;

    @ApiModelProperty(value = "作证材料（文字描述+上传作证材料+网站链接）")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "解决的问题")
    @TableField("SOLVE_PROBLEM_")
    private String solveProblem;

    @ApiModelProperty(value = "取得的成果")
    @TableField("RESULT_")
    private String result;

    @ApiModelProperty(value = "是否涉密（0：否，1：是，如果是涉密那么禁止上传文件，同时给予提示【涉密文件请从内部邮箱发送】）")
    @TableField("CLASSIFIED_")
    private Integer classified;

    @ApiModelProperty(value = "审核状态（0：草稿，1：已录入待审核，2：审核驳回，3：审核通过【改革办待审核】 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成）")
    @TableField("STATUS_")
    private Integer status=0;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "审批意见")
    @TableField(exist = false)
    private String approvalComments;
    
    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty("导入文件")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "文件上传ids")
    @TableField(exist = false)
    private List<String> ids;

    @ApiModelProperty(value = "组织编码")
    @TableField(exist = false)
    private String orgCode;

    @ApiModelProperty(value = "改革事项")
    @TableField(exist = false)
    private String effectTopic;

    @ApiModelProperty(value = "审批操作状态0：通过，1：驳回，2：撤回")
    @TableField(exist = false)
    private Integer approvalResults;
}
