package com.artfess.reform.fill.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.manager.BizReformPilotCityManagementManager;
import com.artfess.reform.fill.manager.BizReformPilotManagementManager;
import com.artfess.reform.fill.model.BizReformIteratePilotManagement;
import com.artfess.reform.fill.dao.BizReformIteratePilotManagementDao;
import com.artfess.reform.fill.manager.BizReformIteratePilotManagementManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.model.BizReformPilotCityManagement;
import com.artfess.reform.fill.model.BizReformPilotManagement;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;

/**
 * 试点迭代管理表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-07-13
 */
@Service
public class BizReformIteratePilotManagementManagerImpl extends BaseManagerImpl<BizReformIteratePilotManagementDao, BizReformIteratePilotManagement> implements BizReformIteratePilotManagementManager {
@Resource
private BizReformPilotManagementManager bizReformPilotManagementManager;
@Resource
private BizReformPilotCityManagementManager bizReformPilotCityManagementManager;
@Resource
private AchieveStatusLogManager achieveStatusLogManager;

    @Override
    public PageList<BizReformIteratePilotManagement> queryPageInfo(QueryFilter<BizReformIteratePilotManagement> queryFilter) {
        queryFilter.addFilter("iter.num",1,QueryOP.EQUAL);
        IPage<BizReformIteratePilotManagement> iPage = baseMapper.queryPageInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter,currentModelClass()));
        return new PageList<>(iPage);
    }

//    @Override
//    public PageList<BizReformIteratePilotManagement> queryCityPageInfo(QueryFilter<BizReformIteratePilotManagement> queryFilter) {
//        queryFilter.addFilter("iter.num",1,QueryOP.EQUAL);
//        IPage<BizReformIteratePilotManagement> iPage = baseMapper.queryPageInfo(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter,currentModelClass()));
//        return new PageList<>(iPage);
//    }

    @Override
    @Transactional
    public void updateIterateStatus(BizReformIteratePilotManagement bizReformIteratePilotManagement)  {
        Assert.notNull(bizReformIteratePilotManagement.getId(),"项目id不能为空");
        Assert.notNull(bizReformIteratePilotManagement.getStatus(),"需修改的状态不能为空");
        Assert.notNull(bizReformIteratePilotManagement.getPilotId(),"关联的项目id不能为空");
        Integer status = bizReformIteratePilotManagement.getStatus();
        String pilotId = bizReformIteratePilotManagement.getPilotId();
        UpdateWrapper<BizReformIteratePilotManagement> updateIterWrapper = new UpdateWrapper<>();
        updateIterWrapper.eq("id_",bizReformIteratePilotManagement.getId());
        updateIterWrapper.set("status_",bizReformIteratePilotManagement.getStatus());
        super.update(updateIterWrapper);
            BizReformIteratePilotManagement entity = super.getById(bizReformIteratePilotManagement.getId());
            if (entity!=null){
                if(entity.getPilotType()!=null&&entity.getPilotType()==0){
                //当改革办审核通过时,更新主表信息
                if (status==3){
                    UpdateWrapper<BizReformPilotManagement> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("ID_",pilotId);
                    updateWrapper.set("acceptance_time_",entity.getIterAcceptanceTime());
                    updateWrapper.set("time_period_",entity.getIterTimePeriod());
                    bizReformPilotManagementManager.update(updateWrapper);
                }else if(bizReformIteratePilotManagement.getApprovalResults()!=null&&bizReformIteratePilotManagement.getApprovalResults()==2&&status==1){
                    UpdateWrapper<BizReformPilotManagement> updateWrapper = new UpdateWrapper<>();
                    updateWrapper.eq("ID_",pilotId);
                    updateWrapper.set("acceptance_time_",entity.getAcceptanceTime());
                    updateWrapper.set("time_period_",entity.getTimePeriod());
                    bizReformPilotManagementManager.update(updateWrapper);
                }
            } else if(entity.getPilotType()!=null&&entity.getPilotType()==1){
                    //当改革办审核通过时,更新主表信息
                    if (status==3){
                        UpdateWrapper<BizReformPilotCityManagement> updateWrapper = new UpdateWrapper<>();
                        updateWrapper.eq("ID_",pilotId);
                        updateWrapper.set("acceptance_time_",entity.getIterAcceptanceTime());
                        updateWrapper.set("time_period_",entity.getIterTimePeriod());
                        bizReformPilotCityManagementManager.update(updateWrapper);
                    } else if(bizReformIteratePilotManagement.getApprovalResults()!=null&&bizReformIteratePilotManagement.getApprovalResults()==2&&status==1){
                        UpdateWrapper<BizReformPilotCityManagement> updateWrapper = new UpdateWrapper<>();
                        updateWrapper.eq("ID_",pilotId);
                        updateWrapper.set("acceptance_time_",entity.getAcceptanceTime());
                        updateWrapper.set("time_period_",entity.getTimePeriod());
                        bizReformPilotCityManagementManager.update(updateWrapper);
                    }
                }
        }


        setApprovalLog(bizReformIteratePilotManagement,null);
    }

    @Override
    @Transactional
    public void setApprovalLog(BizReformIteratePilotManagement entity, Integer type) {
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(entity.getId());
        logVo.setModeType(1);
        logVo.setModuleTableName("BIZ_REFORM_ITER_PILOT_MANAGEMENT");
        if (BeanUtils.isEmpty(entity.getApprovalResults())){
                if (entity.getStatus() == 0) {
                    logVo.setItemTitle("【" + entity.getPilotProjectName() + "】保存为草稿");
                    logVo.setOperateInfo("保存为草稿");
                } else if (entity.getStatus() == 1) {
                    logVo.setItemTitle("【" + entity.getPilotProjectName() + "】改革办核准驳回");
                    logVo.setOperateInfo("提交改革办核准");
                } else if (entity.getStatus() == 2) {
                    logVo.setItemTitle("【" + entity.getPilotProjectName() + "】改革办核准通过");
                    logVo.setOperateInfo("改革办核准驳回");
                }else if (entity.getStatus() == 3) {
                    logVo.setItemTitle("【" + entity.getPilotProjectName() + "】改革办核准通过");
                    logVo.setOperateInfo("改革办核准通过");
                }
                logVo.setApprovalResults(entity.getStatus() % 2 == 0&&entity.getStatus()!=0?1:0);
            }else if (entity.getApprovalResults()==2){
                if (entity.getStatus()==0){
                    logVo.setItemTitle("【"+entity.getPilotProjectName()+"】撤回为草稿");
                    logVo.setOperateInfo("撤回为草稿");
                } else if (entity.getStatus()==1){
                    logVo.setItemTitle("【"+entity.getPilotProjectName()+"】撤回为提交改革办核准");
                    logVo.setOperateInfo("撤回为提交改革办核准");
                }
                logVo.setApprovalResults(2);
            }
        logVo.setStatus(entity.getStatus().toString());
        logVo.setApprovalComments(entity.getApprovalComments());
        logVo.setBizType("5");
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        logVo.setOperateDate(LocalDateTime.now());
        logVo.setModeType(0);
        logVo.setPriority(0);
        if (BeanUtils.isNotEmpty(logVo))achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }

    @Override
    public BizReformIteratePilotManagement getById(String id) {
        Assert.notNull(id,"项目id不能为空");
        BizReformIteratePilotManagement entity = super.getById(id);
        if (entity!=null){
            //从操作日志记录表中获取提交驳回意见
            AchieveStatusLog log = achieveStatusLogManager.getOne(new QueryWrapper<AchieveStatusLog>()
                    .eq("BIZ_ID_", entity.getId())
                    .orderByDesc("OPERATE_DATE_")
                    .last("LIMIT 1"));
            if (BeanUtils.isNotEmpty(log))entity.setApprovalComments(log.getApprovalComments());
        }
        return entity;
    }

}
