package com.artfess.reform.fill.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.artfess.base.manager.BaseManager;
import com.artfess.reform.fill.vo.WorkReportNumVO;

import java.util.List;

/**
 * 工作报告管理 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
public interface BizReformWorkReportManager extends BaseManager<BizReformWorkReport> {
    /**
     * 新增或者修改实体类
     * @param bizReformWorkReport
     * @return
     */
    boolean insertOrUpdateInfo(BizReformWorkReport bizReformWorkReport);

    /**
     * 删除实体类
     * @param ids
     */
    void removeInfo(String ids);

    /**
     * 分页查询
     * @param queryFilter
     * @return
     */
    PageList<BizReformWorkReport> pageList(QueryFilter<BizReformWorkReport> queryFilter);

    /**
     * 工作台各个板块需处理事件数量
     * @return
     */
    List<WorkReportNumVO> countNum();
}
