package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizDigitalConstruction;
import com.artfess.reform.fill.manager.BizDigitalConstructionManager;

import java.time.LocalDateTime;

/**
 * 推动数字重庆建设 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@RestController
@RequestMapping("/fill/bizDigitalConstruction/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "推动数字重庆建设")
public class BizDigitalConstructionController extends BaseController<BizDigitalConstructionManager, BizDigitalConstruction> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加数据接口")
    public CommonResult<String> create(@RequestBody BizDigitalConstruction bizDigitalConstruction) {
        baseService.create(bizDigitalConstruction);
        return CommonResult.success(bizDigitalConstruction.getId(), "数据保存成功！");

    }

    @Override
    @PutMapping("/")
    @ApiOperation("修改数据接口")
    public CommonResult<String> updateById(@RequestBody BizDigitalConstruction bizDigitalConstruction) {
        boolean res = baseService.updateByStatus(bizDigitalConstruction);
        return CommonResult.success(bizDigitalConstruction.getId(),res? "数据更新成功!":"数据更新失败");
    }

    @PostMapping("/getCreateById")
    @ApiOperation("区县填报")
    public BizDigitalConstruction getCreateById(@RequestParam(value = "id",required = false) String id) {
        return baseService.getByCreate(id);
    }

    @PostMapping("/getAuditById")
    @ApiOperation("区县审核")
    public BizDigitalConstruction getAuditById(@RequestParam(value = "id",required = false) String id) {
        return baseService.getByAudit(id);
    }

    @PostMapping("/getExamineById")
    @ApiOperation("改革办审核")
    public BizDigitalConstruction getExamineById(@RequestParam(value = "id",required = false) String id) {
        return baseService.getExamineById(id);
    }

    @PostMapping("/getHisById")
    @ApiOperation("查询历史记录")
    public BizDigitalConstruction getHisById(@RequestParam(value = "unitId",required = false) String unitId,@RequestParam(value = "date",required = false)@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") LocalDateTime date,@RequestParam(value = "isAffirm")boolean isAffirm) {
        return baseService.getHisById(unitId,date,isAffirm);
    }

    @PostMapping(value="/queryByPage")
    @ApiOperation("分页查询")
    public PageList<BizDigitalConstruction> queryPush(@RequestBody QueryFilter<BizDigitalConstruction> queryFilter) {
        return  baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/invIsNew")
    @ApiOperation("查询是否是该区县最新一条数据")
    public boolean invIsNew(@RequestParam(value = "id",required = false) String id,@RequestParam(value = "unitId")String unitId) {
        return  baseService.invIsNew(id,unitId);
    }
}
