package com.artfess.reform.approvalLog.vo;

import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 举措迭代已保存进行提交审核请求参数
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@ApiModel(value="AchieveStatusLogAndAuditResultVo对象", description="功能审批操作日志及审批记录对象")
public class AchieveStatusLogAndAuditResultVo extends AchieveStatusLog {


    @ApiModelProperty(value = "计划规定的完成时间")
    private LocalDateTime planCompleteDate;

    @ApiModelProperty(value = "打开系统调用访问的URL应用链接，也可以是本地系统路由地址。访问之后改变状态。")
    private String url;

    @ApiModelProperty(value = "优先级（0 一般；1紧急；2 特急；3其他）,默认为一般")
    private Integer priority;

    @ApiModelProperty(value = "执行模式（1：并行操作  2：抢占操作）")
    private Integer modeType;

    @ApiModelProperty(value = "流程是否结束（false：流程还没有结束，true：流程已结束），必须传入，用于标记流程是否结束，结束时不再创建发送任务")
    private boolean finish = false;

}
