package com.artfess.reform.utils;

import com.artfess.i18n.util.I18nUtil;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * 注解接口实现
 */
public class FieldRepeatClass implements ConstraintValidator<FieldRepeat, Object> {

    @Autowired
    FieldRepeatUtils fieldRepeatUtils;

    private String[] fileds;
    private String message;
    private Class[] groups;

    @Override
    public void initialize(FieldRepeat validator) {
        this.fileds = validator.fields();
        this.message = validator.message();
        this.groups = validator.groups();
    }

    @SneakyThrows
    @Override
    public boolean isValid(Object o, ConstraintValidatorContext constraintValidatorContext) {
        Class[] groups = this.groups;
        String resposeMsg = I18nUtil.getMessage(message, LocaleContextHolder.getLocale());
        return fieldRepeatUtils.fieldRepeat(fileds, resposeMsg, o);
    }
}
