package com.artfess.reform.majorProjects.vo;

import com.artfess.reform.majorProjects.model.PilotMeasuresPush;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * 改革方案明确的月度计划推进详情包括月度计划信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@Data
@ApiModel(value="PilotMeasuresPushVo对象", description="改革方案明确的月度计划推进详情包括月度计划信息")
public class PilotMeasuresPushVo extends PilotMeasuresPush {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "项目类型(1:加快实施一批，2:准备启动一批，3:谋划储备一批)")
    private Integer projectType;

    @ApiModelProperty(value = "牵头市领导")
    private String leader;

    @ApiModelProperty(value = "所属领域（使用字典，1：政治，2：经济，3：文化，4：社会，5：生态）")
    private Integer projectField;

    @ApiModelProperty(value = "所属跑道（使用字典，1：党的建设，2：XX）")
    private Integer projectRunway;

    @ApiModelProperty(value = "重大项目下发状态（ 0：未下发，1：已下发）")
    private Integer sendStatus;

    @ApiModelProperty(value = "责任单位NAME（关联组织机构表名称）")
    private String unitName;

    @ApiModelProperty(value = "计划年度")
    private Integer planYear;

    @ApiModelProperty(value = "计划季度")
    private Integer planQuarter;

    @ApiModelProperty(value = "计划月度")
    private Integer planMonth;

    @ApiModelProperty(value = "计划内容")
    private String planContent;

    @ApiModelProperty(value = "进行状态（1：未开始，2：进行中，3：已完成）")
    private Integer progressStatus;

    @ApiModelProperty(value = "计划完成时间")
    private LocalDate plannedCompletionTime;

    @ApiModelProperty(value = "实际完成时间")
    private LocalDate actualCompletionTime;

    @ApiModelProperty(value = "备注")
    private String remarks;


}
