package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.reform.majorProjects.manager.MunicipalMajorProjectManagementManager;
import com.artfess.reform.majorProjects.manager.PilotProjectFillManager;
import com.artfess.reform.majorProjects.model.MunicipalMajorProjectManagement;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.model.PilotQuantitativeObjectivesPush;
import com.artfess.reform.majorProjects.vo.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.manager.PilotQuantitativeObjectivesPushManager;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.List;

/**
 * 改革方案量化目标进度计划推进情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/majorProjects/pilotQuantitativeObjectivesPush/v1/")
@Api(tags = "市级重大改革项目管理-改革方案量化目标进度计划推进情况")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotQuantitativeObjectivesPushController extends BaseController<PilotQuantitativeObjectivesPushManager, PilotQuantitativeObjectivesPush> {

    @Resource
    public PilotQuantitativeObjectivesPushManager pilotQuantitativeObjectivesPushManager;

    @Resource
    private MunicipalMajorProjectManagementManager municipalMajorProjectManagementManager;

    /**
     * 审批填报初始化量化目标情况
     * @param pilotProjectFill
     * @return
     */
    @PostMapping("/examineInit")
    @ApiOperation("审批填报初始化-根据项目projectId始化量化审批填报初目标情况")
    public MunicipalMajorProjectManagement getExamineById(@RequestBody PilotProjectFill pilotProjectFill) {
        return municipalMajorProjectManagementManager.getPilotQuantitativeObjectivesVoById(pilotProjectFill);
    }

    @PutMapping("/quantitativeObjectivesPushSave")
    @ApiOperation("目标推进情况审核保存接口")
    public CommonResult<String> quantitativeObjectivesPushSave(@RequestBody QuantitativeObjectivesPushVo quantitativeObjectivesPushVo) {
        pilotQuantitativeObjectivesPushManager.quantitativeObjectivesPushSave(quantitativeObjectivesPushVo);
        return CommonResult.success(quantitativeObjectivesPushVo, "数据保存成功！");
    }


    /**
     * 审批数据查询详情
     * @param id
     * @return
     */
    @GetMapping("/getDetails")
    @ApiOperation("审核-根据ID查询审核数据详情")
    public QuantitativeObjectivesPushFillQueryDetailVo getDetails(@ApiParam(name = "id", value = "填报审核记录ID") @RequestParam(required = true) String id) {
        return pilotQuantitativeObjectivesPushManager.getDetails(id);
    }


    /**
     * 审核-根据项目ID查询历史审核数据详情
     * @param historyDetailsVo
     * @return
     */
    @PostMapping("/getHistoryDetails")
    @ApiOperation("审核-根据项目ID查询历史审核数据详情")
    public QuantitativeObjectivesPushFillQueryDetailVo getHistoryDetails(@RequestBody HistoryDetailsVo historyDetailsVo) {
        return pilotQuantitativeObjectivesPushManager.getHistoryDetails(historyDetailsVo.getProjectId(), historyDetailsVo.getFillDate());
    }




    @PutMapping("/quantitativeObjectivesPushSaveSaveAndCommit")
    @ApiOperation("目标推进情况审核提交接口")
    public CommonResult<String> quantitativeObjectivesPushSaveSaveAndCommit(@RequestBody QuantitativeObjectivesPushVo quantitativeObjectivesPushVo) {
        pilotQuantitativeObjectivesPushManager.quantitativeObjectivesPushSaveSaveAndCommit(quantitativeObjectivesPushVo);
        return CommonResult.success(quantitativeObjectivesPushVo, "数据提交成功！");
    }

    /**
     * 根据ID上报数据详情
     * @param id
     * @return
     */
    @GetMapping("/quantitativeObjectivesPushCommit")
    @ApiOperation("审核-根据ID上报数据")
    public  CommonResult<String> quantitativeObjectivesPushCommit(@ApiParam(name = "id", value = "填报审核记录ID") @RequestParam(required = true) String id) {
        pilotQuantitativeObjectivesPushManager.quantitativeObjectivesPushCommit(id);
        return CommonResult.success(id, "数据上报成功！");
    }


    @PostMapping("/quantitativeObjectivesPushExamine")
    @ApiOperation("目标推进情况领导审核接口")
    public CommonResult<String> quantitativeObjectivesPushExamine(@RequestBody FillPushExamineVo fillPushExamineVo) {
        fillPushExamineVo.setTitle("市级重大项目量化目标推进");
        pilotQuantitativeObjectivesPushManager.quantitativeObjectivesPushExamine(fillPushExamineVo);
        return CommonResult.success(fillPushExamineVo, "数据审核成功！");
    }

    /**
     * 分页查询目标推进情况审核列表数据，包含项目信息，目标信息
     * @param queryFilter
     * @return
     */
    @PostMapping("/quantitativeObjectivesPushListByPage")
    @ApiOperation("目标推进情况审核列表分页查询")
    public PageList<QuantitativeObjectivesPushFillQueryVo> quantitativeObjectivesPushListByPage(@RequestBody QueryFilter<PilotProjectFill> queryFilter) {
        PageList<QuantitativeObjectivesPushFillQueryVo> queryList= pilotQuantitativeObjectivesPushManager.quantitativeObjectivesPushListByPage(queryFilter);
        return queryList;
    }


    @PostMapping(value="/queryTargetList", produces={"application/json; charset=utf-8" })
    @ApiOperation("量化目标清单")
    public List<PilotQuantitativeTargetListVo> queryTargetList(@ApiParam(name="fillYear",value="填报年", required = true)@RequestParam Integer fillYear,
                                                     @ApiParam(name="fillMonth",value="填报月", required = true)@RequestParam Integer fillMonth) {

        return baseService.queryTargetListByFillYearMonth(fillYear,fillMonth);
    }


    @PostMapping(value="/queryMonthPlanList", produces={"application/json; charset=utf-8" })
    @ApiOperation("月度计划清单")
    public List<PilotQuantitativeMonthPlanVo> queryMonthPlanList(@ApiParam(name="fillYear",value="填报年", required = true)@RequestParam Integer fillYear,
                                                    @ApiParam(name="fillMonth",value="填报月", required = true)@RequestParam Integer fillMonth) {

        return baseService.queryMonthPlanListByFillYearMonth(fillYear,fillMonth);
    }
}
