package com.artfess.reform.majorProjects.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformDemandAssignmentRecord;
import com.artfess.reform.majorProjects.model.PilotProjectFill;
import com.artfess.reform.majorProjects.vo.PilotExperiencePushVo;
import com.artfess.reform.majorProjects.vo.PilotProjectFillCreateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.majorProjects.model.PilotExperiencePush;
import com.artfess.reform.majorProjects.manager.PilotExperiencePushManager;

import java.util.List;

/**
 * 项目经验推广总结情况 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2023-03-13
 */
@RestController
@RequestMapping("/majorProjects/bizPilotExperiencePush/v1/")
@Api(tags = "市级重大改革项目管理-项目经验推广总结情况")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PilotExperiencePushController extends BaseController<PilotExperiencePushManager, PilotExperiencePush> {

    @PostMapping("/saveOrUpdateList")
    @ApiOperation("批量保存或更新")
    public CommonResult saveOrUpdateList(@RequestBody List<PilotExperiencePush> data){
        boolean result = baseService.saveOrUpdateList(data);
        return new CommonResult(result,result?"操作成功":"操作失败");
    }

    @PostMapping("/queryByPage")
    @ApiOperation("分页查询所有数据")
    public CommonResult<PageList<PilotExperiencePush>> queryByPage(@RequestBody QueryFilter<PilotExperiencePush> queryFilter){
        PageList<PilotExperiencePush> result = baseService.queryByPage(queryFilter);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/queryHistory")
    @ApiOperation("查询最新数据")
    public CommonResult<List<PilotProjectFill>> queryHistory(@RequestBody QueryFilter<PilotProjectFill> queryFilter){
        List<PilotProjectFill> result = baseService.queryHistory(queryFilter);
        return new CommonResult(true,"查询成功",result);
    }


    @PostMapping("/detailedById")
    @ApiOperation("根据ID查询详情")
    public CommonResult<PilotExperiencePush> detailedById(@RequestParam("id") String id){
        PilotExperiencePush result = baseService.detailedById(id);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/removeByIds")
    @ApiOperation("根据ID批量删除")
    public CommonResult removeByIds(@RequestParam("ids") String ids){
        boolean result = baseService.removeByIds(ids);
        return new CommonResult(result,result?"操作成功":"操作失败");
    }

    @PostMapping("/updateAuditStatus")
    @ApiOperation("修改审核状态")
    public CommonResult updateAuditStatus(@RequestBody PilotProjectFill pilotProjectFill) {
        boolean result = baseService.updateAuditStatus(pilotProjectFill);
        return new CommonResult<>(result,result?"操作成功":"操作失败");
    }


    /**
     * 经验推广-保存草稿或提交
     * @param pilotExperiencePushVo
     * @return
     */
    @PutMapping("/saveDraftOrCommit")
    @ApiOperation("经验推广-保存草稿或提交")
    public CommonResult saveDraftOrCommit(@RequestBody PilotExperiencePushVo pilotExperiencePushVo) {
        baseService.saveDraftOrCommit(pilotExperiencePushVo);
        return CommonResult.success(pilotExperiencePushVo.getPilotExperiencePushList().get(0).getProjectId(), "数据保存成功");
    }


}
