package com.artfess.reform.fill.vo;


import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author 陈实
 * @Package com.artfess.reform.fill.vo
 * @date 2023/3/18 16:22
 * @Description:
 */
@Data
public class SynReportVo {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "项目ID")
    private String projectId;

    @ApiModelProperty(value = "项目名称")
    private String projectName;

    @ApiModelProperty(value = "项目类型")
    private String projectType;

    @ApiModelProperty(value = "主键_id")
    private String brandId;

    @ApiModelProperty(value = "评比日期")
    private LocalDate brandDate;

    @ApiModelProperty(value = "评比年")
    private Integer brandYear;

    @ApiModelProperty(value = "评比季度")
    private Integer brandQuarter;

    @ApiModelProperty(value = "评比月")
    private Integer brandMonth;

    @ApiModelProperty(value = "改革经验获全国性肯定评价件次")
    private Integer nationwideNum;

    @ApiModelProperty(value = "改革经验获全国性肯定评价得分")
    private BigDecimal nationwideScore;

    @ApiModelProperty(value = "改革经验获全市推广件次")
    private Integer cityNum;

    @ApiModelProperty(value = "改革经验获全市推广得分")
    private BigDecimal cityScore;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道件次")
    private Integer mediaNum;

    @ApiModelProperty(value = "改革经验被5家中央媒体深度专题报道得分")
    private BigDecimal mediaScore;

    @ApiModelProperty(value = "品牌显示度得分")
    private BigDecimal brandScore;

    @ApiModelProperty(value = "品牌显示得分全市排名")
    private Integer brandAllSn;

    @ApiModelProperty(value = "品牌显示蝉联次数")
    private Integer brandHoldNum;

    @ApiModelProperty(value = "主键_id")
    private String measureId;

    @ApiModelProperty(value = "评比日期")
    private LocalDate measureDate;

    @ApiModelProperty(value = "评比年")
    private Integer measureYear;

    @ApiModelProperty(value = "评比季度")
    private Integer measureQuarter;

    @ApiModelProperty(value = "评比月")
    private Integer measureMonth;

    @ApiModelProperty(value = "明确措施个数")
    private Integer measureNum;

    @ApiModelProperty(value = "月度计划个数")
    private Integer planNum;

    @ApiModelProperty(value = "月度完成个数")
    private Integer planReachNum;

    @ApiModelProperty(value = "月度完成率")
    private BigDecimal planReachRate;

    @ApiModelProperty(value = "明确形成制度个数")
    private Integer regimeNum;

    @ApiModelProperty(value = "实际形成制度个数")
    private Integer actualRegimeNum;

    @ApiModelProperty(value = "形成制度得分")
    private BigDecimal regimeScore;

    @ApiModelProperty(value = "明确上线应用个数")
    private Integer appNum;

    @ApiModelProperty(value = "实际上线应用个数")
    private Integer actualAppNum;

    @ApiModelProperty(value = "实际搭建平台个数")
    private Integer platformNum;

    @ApiModelProperty(value = "明确搭建平台个数")
    private Integer actualPlatformNum;

    @ApiModelProperty(value = "搭建平台上线应用得分")
    private BigDecimal appPlatformScore;

    @ApiModelProperty(value = "具体举措推进力评分")
    private BigDecimal measureScore;

    @ApiModelProperty(value = "具体举措推进力排名")
    private Integer measureSn;

    @ApiModelProperty(value = "蝉联次数")
    private Integer measureHoldNum;

    @ApiModelProperty(value = "主键_id")
    private String targetId;

    @ApiModelProperty(value = "评比日期")
    private LocalDateTime targetDate;

    @ApiModelProperty(value = "评比年")
    private Integer targetYear;

    @ApiModelProperty(value = "评比季度")
    private Integer targetQuarter;

    @ApiModelProperty(value = "评比月")
    private Integer targetMonth;

    @ApiModelProperty(value = "明确目标个数")
    private Integer targetNum;

    @ApiModelProperty(value = "达成目标个数")
    private Integer reachNum;

    @ApiModelProperty(value = "目标达成率")
    private BigDecimal reachRate;

    @ApiModelProperty(value = "目标推进力评分")
    private BigDecimal targetScore;

    @ApiModelProperty(value = "目标推进力排名")
    private Integer targetSn;

    @ApiModelProperty(value = "蝉联次数")
    private Integer targetHoldNum;

    @ApiModelProperty(value = "主键_id")
    private String synId;

    @ApiModelProperty(value = "评比日期")
    private LocalDate synDate;

    @ApiModelProperty(value = "评比年")
    private Integer synYear;

    @ApiModelProperty(value = "评比季度")
    private Integer synQuarter;

    @ApiModelProperty(value = "评比月")
    private Integer synMonth;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件件次")
    private Integer opinionNum;

    @ApiModelProperty(value = "引发重大负面舆情或群体性事件扣分")
    private BigDecimal opinionScore;

    @ApiModelProperty(value = "综合得分")
    private BigDecimal score;

    @ApiModelProperty(value = "综合得分全市排名")
    private Integer allSn;

    @ApiModelProperty(value = "主键_ID")
    private String satId;

    @ApiModelProperty(value = "调查年份")
    private Integer scoringYear;

    @ApiModelProperty(value = "调查季度")
    private Integer scoringQuarter;

    @ApiModelProperty(value = "调查月份")
    private Integer scoringMonth;

    @JsonFormat(pattern="yyyy-MM-dd",timezone="GMT+8")
    @ApiModelProperty(value = "调查日期")
    private Date scoringDate;

    @ApiModelProperty(value = "满意度")
    private BigDecimal satisfaction;


}
