package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDateTime;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 需求交办推进记录表
 *
 * @DEPT 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-07
 */
@TableName("BIZ_REFORM_DEMAND_ASSIGNMENT_RECORD")
@ApiModel(value="BizReformDemandAssignmentRecord对象", description="需求交办推进记录表")
@Data
public class BizReformDemandAssignmentRecord extends AutoFillFullModel<BizReformDemandAssignmentRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "需求交办id关联需求交办主表")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "下一步工作计划")
    @TableField("WORK_PLAN_")
    private String workPlan;

    @ApiModelProperty(value = "推进状态使用字典，：1：未启动，2：推进中，3：已完成")
    @TableField("PROPULSIVE_STATUS_")
    private Integer propulsiveStatus;

    @ApiModelProperty(value = "推进详情详情描述")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "存在问题")
    @TableField("EXISTING_PROBLEMS_")
    private String existingProblems;

    @ApiModelProperty(value = "填报时间")
    @TableField("REPORTING_TIME")
    private LocalDateTime reportingTime;

    @ApiModelProperty(value = "填报单位_id")
    @TableField("REPORTING_UNIT_ID_")
    private String reportingUnitId;

    @ApiModelProperty(value = "填报单位_name")
    @TableField("REPORTING_UNIT_NAME_")
    private String reportingUnitName;

    @ApiModelProperty("是否涉密文件")
    @TableField("CLASSIFIED_")
    private String classified;

    @ApiModelProperty(value = "填报单位code")
    @TableField("RESPONSIBLE_UNIT_CODE_")
    private String responsibleUnitCode;

    @ApiModelProperty(value = "填报单位grade")
    @TableField("RESPONSIBLE_UNIT_GRADE_")
    private String responsibleUnitGrade;

    @ApiModelProperty(value = "审核状态0：草稿，1：已录入待更新，2：审核驳回，3：审核通过改革办待审核 ， 4：改革办审核确认驳回 ， 5：改革办审核确认完成")
    @TableField("STATUS_")
    private Integer status=0;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty("是否历史数据")
    @TableField(exist = false)
    private Boolean isHis;

    @ApiModelProperty(value = "审批意见")
    @TableField(exist = false)
    private String approvalComments;

    @ApiModelProperty(value = "操作步骤0：通过 1：驳回 2：撤回")
    @TableField(exist = false)
    private Integer approvalResults;

    @ApiModelProperty(value = "导入文件集合")
    @TableField(exist = false)
    private List<DefaultFile> files;

    @ApiModelProperty(value = "文件上传ids")
    @TableField(exist = false)
    private List<String> ids;



}
