package com.artfess.reform.fill.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 会议通知表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-09
 */
@TableName("BIZ_MEETING_NOTICE")
@ApiModel(value="BizMeetingNotice对象", description="会议通知表")
@Data
public class BizMeetingNotice extends AutoFillFullModel<BizMeetingNotice> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "会议名称")
    @TableField("MEETING_NAME_")
    private String meetingName;

    @ApiModelProperty(value = "会议时间")
    @TableField("MEETING_TIME_")
    private LocalDateTime meetingTime;

    @ApiModelProperty(value = "会议地点")
    @TableField("MEETING_ADDRESS_")
    private String meetingAddress;

    @ApiModelProperty(value = "其他要求")
    @TableField("PROPULSIVE_DETAILED_")
    private String propulsiveDetailed;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;


}
