package com.artfess.reform.fill.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.approvalLog.manager.AchieveStatusLogManager;
import com.artfess.reform.approvalLog.model.AchieveStatusLog;
import com.artfess.reform.approvalLog.vo.AchieveStatusLogAndAuditResultVo;
import com.artfess.reform.fill.dao.BizReformSatisfactionManagementDao;
import com.artfess.reform.fill.manager.BizReformSatisfactionDistrictsManager;
import com.artfess.reform.fill.manager.BizReformSatisfactionManagementManager;
import com.artfess.reform.fill.manager.UniversalWayManager;
import com.artfess.reform.fill.model.BizReformDemandAssignment;
import com.artfess.reform.fill.model.BizReformSatisfactionDistricts;
import com.artfess.reform.fill.model.BizReformSatisfactionManagement;
import com.artfess.reform.utils.BizUtils;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Service
public class BizReformSatisfactionManagementManagerImpl extends BaseManagerImpl<BizReformSatisfactionManagementDao, BizReformSatisfactionManagement> implements BizReformSatisfactionManagementManager {

    @Resource
    BizReformSatisfactionDistrictsManager bizReformSatisfactionDistrictsManager;
    @Autowired
    UniversalWayManager universalWayManager;
 
    @Resource
    AchieveStatusLogManager achieveStatusLogManager;
    @Resource
    FileManager fileManager;

    @Override
    public PageList<BizReformSatisfactionManagement> queryByPage(QueryFilter<BizReformSatisfactionManagement> queryFilter,boolean isAffirm) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !isAffirm) queryFilter.addFilter("CREATE_ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        IPage<BizReformSatisfactionManagement> bizIdmMemberAnnualFeeIPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(bizIdmMemberAnnualFeeIPage);
    }

    @Override
    @Transactional
    public String saveOrUpdateSatisfaction(BizReformSatisfactionManagement bizReformSatisfactionManagement) {
        bizReformSatisfactionManagement.setScoringDate(new Date());
        QueryWrapper<BizReformSatisfactionManagement> queryWrapper= new QueryWrapper<>();
        queryWrapper.eq("SCORING_YEAR_", bizReformSatisfactionManagement.getScoringYear());
        queryWrapper.eq("SCORING_QUARTER_", bizReformSatisfactionManagement.getScoringQuarter());
        queryWrapper.ne(StringUtil.isNotEmpty(bizReformSatisfactionManagement.getId()),"id_",bizReformSatisfactionManagement.getId());
        int count = baseMapper.selectCount(queryWrapper);
        if(count>0){
            throw new ApplicationException("已经存在【"+bizReformSatisfactionManagement.getScoringYear()+"】年【"+bizReformSatisfactionManagement.getScoringQuarter()+"】季度的数据了！");
        }
        this.saveOrUpdate(bizReformSatisfactionManagement);
        String id = bizReformSatisfactionManagement.getId();
        List<BizReformSatisfactionDistricts> list = bizReformSatisfactionManagement.getBizReformSatisfactionDistricts();
        if(list!=null && list.size()>0){
            bizReformSatisfactionDistrictsManager.batchUpdate(bizReformSatisfactionManagement);
        }

        //更新附件表
        if (BeanUtils.isNotEmpty(bizReformSatisfactionManagement.getIds())) {
            universalWayManager.attachmentUpdates(bizReformSatisfactionManagement.getIds(), bizReformSatisfactionManagement.getId());
        }
        setApprovalLog(id, bizReformSatisfactionManagement.getStatus(),"");
        return id;
    }

    @Override
    public void updateStatusById(String id, Integer status,Integer fileStatus,String approvalComments) {
        if (BeanUtils.isNotEmpty(status)){
            if(status==2 || status==4){
                if(StringUtil.isEmpty(approvalComments)){
                    throw new ApplicationException("请填写驳回理由");
                }
            }
        }
        UpdateWrapper<BizReformSatisfactionManagement> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id_", id).set(BeanUtils.isNotEmpty(status),"status_", status)
                .set(BeanUtils.isNotEmpty(fileStatus),"FILE_STATUS_", fileStatus)
                .set("audit_time_",LocalDateTime.now());
        super.update(updateWrapper);
        if (BeanUtils.isNotEmpty(status))setApprovalLog(id, status,approvalComments);

    }

    @Override
    public BizReformSatisfactionManagement getById(String id) {
        Assert.hasText(id, "id不能为空！");
        BizReformSatisfactionManagement  satisfaction =this.baseMapper.selectById(id);
        if(satisfaction!=null){
            if(satisfaction.getStatus()==2 || satisfaction.getStatus()==4){//驳回查询驳回意见
                AchieveStatusLog log = achieveStatusLogManager.queryAchieveStatusLogByBizIdAndStatus(satisfaction.getId(),satisfaction.getStatus());
                satisfaction.setApprovalComments(log.getApprovalComments());
            }
            List<DefaultFile>files =  fileManager.queryFileByBizId(id);
            if(files!=null && files.size()>0){
                satisfaction.setFileList(files);
            }
            List<BizReformSatisfactionDistricts> list= bizReformSatisfactionDistrictsManager.queryBySatisfactionId(id);
            if(list!=null && list.size()>0){
                satisfaction.setBizReformSatisfactionDistricts(list);
            }
        }
        return satisfaction;
    }

    @Override
    @Transactional
    public CommonResult<String> deleteBatchByIds(String id) {
        Assert.hasText(id, "id集合不能为空！");
        String[] ids = id.split(",");
        for (String res : ids) {
            QueryWrapper queryWrapper = new QueryWrapper<BizReformSatisfactionManagement>();
            queryWrapper.eq("ID_",res);
            queryWrapper.gt("STATUS_", 0);
            Integer num = this.baseMapper.selectCount(queryWrapper);
            if (num>0){
                return new CommonResult<>(false,"已通过审核或正在审核中的方案无法删除");
            }
            bizReformSatisfactionDistrictsManager.remove(new QueryWrapper<BizReformSatisfactionDistricts>().eq(StringUtil.isNotEmpty(res),"satisfaction_id_",res));

            this.baseMapper.deleteById(res);

            universalWayManager.deleteFiles(res);
        }
        return new CommonResult<>(true,"删除成功！");
    }

    @Override
    public PageList<BizReformSatisfactionManagement> pageList(QueryFilter<BizReformSatisfactionManagement> queryFilter) {
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin()) {
            queryFilter.addFilter("CREATE_ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        PageList<BizReformSatisfactionManagement> model = this.query(queryFilter);

        return model;
    }

    @Override
    public PageList<BizReformSatisfactionManagement> auditQuery(QueryFilter<BizReformSatisfactionManagement> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("CREATE_ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", 0, QueryOP.NOT_EQUAL);
        PageList<BizReformSatisfactionManagement> model = this.query(queryFilter);

        return model;
    }

    @Override
    public PageList<BizReformSatisfactionManagement> reformQuery(QueryFilter<BizReformSatisfactionManagement> queryFilter) {
        queryFilter.addFilter("is_dele_", "0", QueryOP.EQUAL);
        PageList<BizReformSatisfactionManagement> model = this.query(queryFilter);

        return model;
    }

    /**
     * 设置审批日志实体类录入
     *
     * @param id
     * @param status
     */
    @Transactional
    public void setApprovalLog(String id, Integer status,String approvalComments) {
        // 审批日志
        BizReformSatisfactionManagement  satisfaction =this.baseMapper.selectById(id);
        String title =satisfaction.getScoringYear()+"年"+ satisfaction.getScoringQuarter()+"季度 "+satisfaction.getEstigationName();
        AchieveStatusLogAndAuditResultVo logVo = new AchieveStatusLogAndAuditResultVo();
        logVo.setBizId(id);
        logVo.setModeType(1);
        logVo.setBizType("7");
        logVo.setModuleTableName("biz_reform_satisfaction_management");
        logVo.setApprovalComments(approvalComments);
        if (status % 2 == 0) {
            logVo.setApprovalResults(1);
        } else {
            logVo.setApprovalResults(0);
        }
        //0：草稿，1：已录入待审核，2：录入组织领导审核驳回，3：录入组织领导审核通过，4.改革办审核驳回 5.改革办审核通过
        if(status==0){
            logVo.setItemTitle("【"+title+"】录入！");
            logVo.setOperateInfo("区县满意度调查信息录入！");
            logVo.setApprovalResults(0);
        }else if(status==1){
            logVo.setItemTitle("【"+title+"】提交审核！");
            logVo.setOperateInfo("提交审核");
            logVo.setApprovalResults(0);
        }else if(status==2){
            logVo.setItemTitle("【"+title+"】审核驳回！");
            logVo.setOperateInfo("审核驳回");
            logVo.setApprovalResults(1);
        }else if(status==3){
            logVo.setItemTitle("【"+title+"】审核通过！");
            logVo.setOperateInfo("审核通过");
            logVo.setApprovalResults(0);
        }else if(status==4){
            logVo.setItemTitle("【"+title+"】改革办驳回！");
            logVo.setOperateInfo("改革办驳回");
            logVo.setApprovalResults(1);
        }else if(status==5){
            logVo.setItemTitle("【"+title+"】改革办通过！");
            logVo.setOperateInfo("改革办通过");
            logVo.setApprovalResults(0);
        }

        logVo.setStatus(status.toString());
        logVo.setModeType(0);
        logVo.setPriority(0);
        logVo.setCreateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgId(ContextUtil.getCurrentOrgId());
        logVo.setOperateOrgName(ContextUtil.getCurrentOrgName());
        logVo.setOperateDeptId(ContextUtil.getCurrentDeptId());
        logVo.setOperateDeptName(ContextUtil.getCurrentDeptName());
        logVo.setOperateUserId(ContextUtil.getCurrentUserId());
        logVo.setOperateUserName(ContextUtil.getCurrentUserName());
        logVo.setOperateDate(LocalDateTime.now());
        // 保存审批日志
        achieveStatusLogManager.createAchieveStatusLogAndAuditResult(logVo);
    }
}
