package com.artfess.reform.fill.manager.impl;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.reform.fill.manager.BizDigitalShareApplicationManager;
import com.artfess.reform.fill.model.BizDigitalShareApplication;
import com.artfess.reform.fill.dao.BizDigitalShareApplicationDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.reform.fill.model.BizDigitalThreeLists;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 特色应用“一地创新、全市共享”情况 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-08-23
 */
@Service
public class BizDigitalShareApplicationManagerImpl extends BaseManagerImpl<BizDigitalShareApplicationDao, BizDigitalShareApplication> implements BizDigitalShareApplicationManager {
    @Resource
    FileManager fileManager;
    @Override
    public List<BizDigitalShareApplication> selectByUnitId(String unitId) {
        List<BizDigitalShareApplication> list = baseMapper.selectByUnitId(unitId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalShareApplication> selectAuditById(String id) {
        List<BizDigitalShareApplication> list = baseMapper.selectAuditById(id);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public List<BizDigitalShareApplication> selectExamineById(String id,String unitId) {
        List<BizDigitalShareApplication> list = baseMapper.selectExamineById(id,unitId);
        list.stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return list;
    }

    @Override
    public PageList<BizDigitalShareApplication> queryByPage(QueryFilter<BizDigitalShareApplication> queryFilter) {
        queryFilter.addFilter("s.NUM",1,QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.CREATE_ORG_ID_", Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalShareApplication> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }

    @Override
    public PageList<BizDigitalShareApplication> queryByPageNew(QueryFilter<BizDigitalShareApplication> queryFilter) {
        queryFilter.addFilter("s.NUM",1,QueryOP.EQUAL);
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("s.CREATE_ORG_ID_", Direction.ASC));
        queryFilter.setSorter(sorter);
        IPage<BizDigitalShareApplication> iPage = baseMapper.queryByPageNew(convert2IPage(queryFilter.getPageBean()),convert2Wrapper(queryFilter, currentModelClass()));
        iPage.getRecords().stream().forEach(p->{
            List<DefaultFile> files = fileManager.queryFileByBizId(p.getId());
            p.setFiles(files);
        });
        return new PageList<>(iPage);
    }
}
