package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizPilotAdvanceResult;
import com.artfess.reform.statistics.vo.CountyPilotReformVo;

import java.util.List;

public interface BizPilotAdvanceResultManager extends BaseManager<BizPilotAdvanceResult> {

    /**
     * 为各成果形式统计成果数量
     * @param type 类型：0 累计数、1 当前季度总数
     * @param year 年份
     * @param quarter 季度
     * @param unitCode  区县编码
     * @return
     */
    List<CountyPilotReformVo> count(int type,Integer year,Integer quarter,String unitCode);

    /**
    * @Description: 分页查询详情结果
    * @param queryFilter
    * @Return: com.artfess.base.query.PageList<com.artfess.reform.fill.model.BizPilotAdvanceResult>
    * @Author: chens
    * @Date: 2023/4/18 12:51
    */
    PageList<BizPilotAdvanceResult> pilotResultDetail(QueryFilter<BizPilotAdvanceResult> queryFilter);

    List<BizPilotAdvanceResult> queryDeleteById(String recId);

}
