package com.artfess.reform.fill.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizMeetingEventPush;

import java.util.List;

/**
 * @Description:会议议定事项推进表 服务类
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:15
 */
public interface BizMeetingEventPushManager extends BaseManager<BizMeetingEventPush> {
    /**
     * 批量添加或修改数据
     * @param bizMeetingEventPushList
     */
//    void saveOrUpdateList(List<BizMeetingEventPush> bizMeetingEventPushList);

    /**
     * 添加或修改数据
     * @param bizMeetingEventPush
     */
    void saveOrUpdateEntity(BizMeetingEventPush bizMeetingEventPush);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizMeetingEventPush> queryByPage(QueryFilter<BizMeetingEventPush> queryFilter);

    /**
     * 查询最近历史数据
     * @param queryFilter
     * @return
     */
    List<BizMeetingEventPush> queryHistory(QueryFilter<BizMeetingEventPush> queryFilter);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizMeetingEventPush detailedById(String id);

    /**
     * 根据id修改状态
     * @param
     * @param status
     * @return
     */
    boolean modifyStatus(String id,String projectId, Integer approvalResults ,String status);

    /**
     * 审核
     * @param bizMeetingEventPush
     * @return
     */
    void examineAndVerify(BizMeetingEventPush bizMeetingEventPush);
}
