package com.artfess.reform.fill.dto;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.List;

@Data
public class MentDTO {
    @ApiModelProperty(value = "主键id")
    public String id;
    @ApiModelProperty(value = "组织id")
    public String unitId;
    @ApiModelProperty(value = "文号")
    public String docNo;
    @ApiModelProperty(value = "区县名称")
    public String unitName;
    @ApiModelProperty(value = "市级主管部门")
    public String mainUnitName;
    @ApiModelProperty(value = "试点项目名称")
    public String projectName;
    @ApiModelProperty(value = "试点层级（使用字典，1：国家级，2：市级）")
    public Integer pilotLevel;
    @ApiModelProperty(value = "主管部委（使用级联字典，与试点层级级联，1：外交部，2：国防部，3：发展改革委，请自行百度搜索全的）")
    public Integer pilotSupervisor;
    @ApiModelProperty(value = "试点目标")
    public String pilotTarget;
    @ApiModelProperty(value = "推进状态（子表更新后自动更新）")
    public Integer propulsiveStatus;
    @ApiModelProperty(value = "状态")
    public Integer status;
    @ApiModelProperty(value = "所属领域")
    public Integer pilotField;
    @ApiModelProperty(value = "所属跑道")
    public Integer pilotRunway;
    @ApiModelProperty(value = "状态集合")
    public List<Integer> statusList;
    @ApiModelProperty(value = "分页大小")
    public Integer size;
    @ApiModelProperty(value = "分页页数")
    public Integer page;
    @ApiModelProperty(value = "创建人组织id")
    public String createOrgId;
    @ApiModelProperty(value = "是否删除 0未删除 1删除")
    public String isDele;
}
