package com.artfess.reform.fill.dao;


import com.artfess.reform.fill.model.BizReformRiskManagement;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface BizReformRiskManagementDao extends BaseMapper<BizReformRiskManagement> {
    IPage<BizReformRiskManagement> pageQuery(IPage<BizReformRiskManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizReformRiskManagement> convert2Wrapper);

    /**
    * @Description:
    * @param riskYear 风险发生年
    * @param riskQuarter  风险发生季度
    * @param riskMonth  风险发生月
    * @param riskType  风险类型（1：重大负面舆情，2：群里性事件）
    * @param significant    风险涉及对象类型（0：重大项目，1：区县）
    * @Return: java.util.List<com.artfess.reform.fill.model.BizReformRiskManagement>
    * @Author: chens
    * @Date: 2023/4/12 19:43
    */
    List<BizReformRiskManagement> queyList( @Param("riskYear") Integer riskYear,@Param("riskQuarter") Integer riskQuarter,@Param("riskMonth") Integer riskMonth,@Param("riskType") Integer riskType,
                                            @Param("significant") Integer significant);

    IPage<BizReformRiskManagement> queryByPage(IPage<BizReformRiskManagement> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizReformRiskManagement> convert2Wrapper);
}
