package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.model.BizReformWorkReport;
import com.artfess.uc.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizSpecialGroup;
import com.artfess.reform.fill.manager.BizSpecialGroupManager;

import java.util.List;

/**
 * 专项小组信息信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-05-15
 */
@RestController
@RequestMapping("/fill/bizSpecialGroup/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "专项小组信息")
public class BizSpecialGroupController extends BaseController<BizSpecialGroupManager, BizSpecialGroup> {

    @PostMapping(value="/saveOrUpdateEntity")
    @ApiOperation("S-添加或修改实体类")
    public CommonResult<String> saveOrUpdateEntity(@RequestBody BizSpecialGroup bizSpecialGroup) {
        boolean res = baseService.saveOrUpdateEntity(bizSpecialGroup);
        if (!res){
            return new CommonResult<>(bizSpecialGroup.getId()==null?"添加失败":"修改失败");
        }
        return new CommonResult<>(bizSpecialGroup.getId()==null?"添加成功":"修改成功");
    }


    @PostMapping(value="/deleteEntity/{id}")
    @ApiOperation("S-删除数据")
    public CommonResult<String> deleteEntity(@PathVariable("id") String id) {
        baseService.deleteEntity(id);
        return new CommonResult<>("删除成功");
    }

    @PostMapping(value="/findById/{id}")
    @ApiOperation("S-根据id查询详情")
    public BizSpecialGroup findById(@PathVariable("id") String id) {
        return baseService.findById(id);
    }

    @PostMapping(value="/isRepeat")
    @ApiOperation("S-判断是否存在相同小组名称")
    public boolean isRepeat(@RequestParam(value = "id",required = false ) String id,@RequestParam("name") String name) {
        return baseService.isRepeat(id,name);
    }


    @PostMapping(value="/queryPageList")
    @ApiOperation("S-分页查询")
    public PageList<BizSpecialGroup> queryPageList(@RequestBody QueryFilter<BizSpecialGroup> queryFilter) {
        return baseService.queryPageList(queryFilter);
    }
}
