package com.artfess.reform.fill.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.reform.fill.model.BizReformProjectCounty;
import com.artfess.reform.fill.manager.BizReformProjectCountyManager;

/**
 * 区县自主探索改革项目管理表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-03-10
 */
@RestController
@RequestMapping("/bizReformProjectCounty/v1/")
@Api(tags = "区县自主探索改革项目管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReformProjectCountyController extends BaseController<BizReformProjectCountyManager, BizReformProjectCounty> {


    @Override
    @PostMapping("insertInfo/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@RequestBody BizReformProjectCounty bizReformProjectCounty) {
        return super.create(bizReformProjectCounty);
    }

    @Override
    @PostMapping("selectList/")
    @ApiOperation("列表查询")
    public PageList<BizReformProjectCounty> query(@RequestBody QueryFilter<BizReformProjectCounty> queryFilter) {
        return super.query(queryFilter);
    }


    @Override
    @PostMapping("updateInfo/")
    @ApiOperation("修改实体的接口")
    public CommonResult<String> updateById(@RequestBody BizReformProjectCounty bizReformProjectCounty) {
        return super.updateById(bizReformProjectCounty);
    }

    @Override
    @GetMapping("delete/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        return super.deleteById(id);
    }

    @Override
    @GetMapping("deleteByIds")
    @ApiOperation("根据id批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        return super.deleteByIds(ids);
    }
}
