package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.manager.BizMeetingEventPushManager;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.artfess.reform.fill.model.BizMeetingEventPush;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:会议议定事项推进表 前端控制器
 * @Author: Rong Tao
 * @Date: 2023/4/3 17:17
 */
@RestController
@RequestMapping("/bizMeetingEventPush/v1/")
@Api(tags = "会议议定事项推进")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingEventPushController extends BaseController<BizMeetingEventPushManager, BizMeetingEventPush> {

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("添加或修改")
    public CommonResult saveOrUpdateEntity(@RequestBody BizMeetingEventPush bizMeetingEventPush) {
        baseService.saveOrUpdateEntity(bizMeetingEventPush);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/queryByPage")
    @ApiOperation("分页查询所有数据")
    public CommonResult<PageList<BizMeetingEventPush>> queryByPage(@RequestBody QueryFilter<BizMeetingEventPush> queryFilter) {
        PageList<BizMeetingEventPush> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/queryHistory")
    @ApiOperation("查询最近历史数据")
    public CommonResult<List<BizMeetingEventPush>> queryHistory(@RequestBody QueryFilter<BizMeetingEventPush> queryFilter) {
        List<BizMeetingEventPush> result = baseService.queryHistory(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/detailedById")
    @ApiOperation("根据ID查询详情")
    public CommonResult<BizMeetingEventPush> detailedById(@RequestParam("id") String id) {
        BizMeetingEventPush result = baseService.detailedById(id);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/modifyStatus")
    @ApiOperation("根据ID修改审核状态")
    public CommonResult modifyStatus(@RequestParam("id")String id,@RequestParam("projectId")String projectId, @RequestParam(value = "approvalResults",required = false)Integer approvalResults ,@RequestParam("status")String status) {
        boolean result = baseService.modifyStatus(id,projectId,approvalResults,status);
        return new CommonResult(result,result?"操作成功":"操作失败");
    }

    @PostMapping("/examineAndVerify")
    @ApiOperation("审核")
    public CommonResult examineAndVerify(@RequestBody BizMeetingEventPush bizMeetingEventPush) {
        baseService.examineAndVerify(bizMeetingEventPush);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/revSendStatus")
    @ApiOperation("根据交办事项id查询分发的数据是否已填写")
    public CommonResult<String> revSendStatus(@RequestParam("id") String id) {
        Assert.notNull(id,"需查询的id不能为空");
        List<BizMeetingEventPush> list = baseService.list(new QueryWrapper<BizMeetingEventPush>().eq("MEETING_EVENT_ID_", id).eq("IS_DELE_", "0"));
        if ( list.size()>0){
            return new CommonResult<>(false,"对接责任单位已推进更新,无法撤回");
        }
        return new CommonResult<>(true,"");
    }
}
