package com.artfess.reform.fill.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.reform.fill.manager.BizMeetingEventManager;
import com.artfess.reform.fill.model.BizMeetingEvent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * @Description:会议议定事项表 前端控制器
 * @Author: Rong Tao
 * @Date: 2023/4/3 16:43
 */
@RestController
@RequestMapping("/bizMeetingEvent/v1/")
@Api(tags = "会议议定事项")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizMeetingEventController extends BaseController<BizMeetingEventManager, BizMeetingEvent> {

    @PostMapping("/queryByPage")
    @ApiOperation("分页查询所有数据")
    public CommonResult<PageList<BizMeetingEvent>> queryByPage(@RequestBody QueryFilter<BizMeetingEvent> queryFilter) {
        PageList<BizMeetingEvent> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("添加或修改")
    public CommonResult saveOrUpdateEntity(@RequestBody BizMeetingEvent bizMeetingEvent) {
        baseService.saveOrUpdateEntity(bizMeetingEvent);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/modifySendStatus")
    @ApiOperation("根据ID修改分发状态")
    public CommonResult modifySendStatus(@RequestParam String ids,@RequestParam String status) {
        boolean result = baseService.modifySendStatus(ids, status);
        return new CommonResult(result,result?"操作成功":"操作失败");
    }

    @PostMapping("/detailedById")
    @ApiOperation("根据ID查询详情")
    public CommonResult<BizMeetingEvent> detailedById(@RequestParam(value = "id") String id,@RequestParam(value = "unitId",required = false) String unitId) {
        BizMeetingEvent result = baseService.detailedById(id,unitId);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/isExists")
    @ApiOperation("判断是否存在相同会议名称")
    public boolean isExists(@RequestParam(value = "id",required = false) String id,@RequestParam(value = "meetingName",required = true) String meetingName) {
        return baseService.isExists(id,meetingName);
    }


}
