package com.artfess.reform.utils;

import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.IsoFields;

/**
 * @author 黎沐华
 * @date 2023/3/29 17:24
 */
public class FieldFillUtil {
    public static void fillDateFields(LocalDate currentDate, Object obj) {
        try {
            // 获取当前年、月、季度
            Integer currentYear = currentDate.getYear();
            Integer currentMonth = currentDate.getMonthValue();
            Integer currentQuarter = currentDate.get(IsoFields.QUARTER_OF_YEAR);

            // 设置 fillDate 字段
            Field fillDateField = getField(obj, "fillDate");
            fillDateField.set(obj, LocalDate.now());

            // 设置 fillYear 字段
            Field fillYearField = getField(obj, "fillYear");
            fillYearField.set(obj, currentYear);

            // 设置 fillMonth 字段
            Field fillMonthField = getField(obj, "fillMonth");
            fillMonthField.set(obj, currentMonth);

            // 设置 fillQuarter 字段
            Field fillQuarterField = getField(obj, "fillQuarter");
            fillQuarterField.set(obj, currentQuarter);
            // 如果当前日期是月、季度、年的最后一天，则将 fillType 字段赋值为对应类型（日：D，月：M，季度：Q，年：Y）
            int lastDayOfMonth = currentDate.lengthOfMonth();
            Field fillTypeField = getField(obj, "fillType");
            if (currentDate.getDayOfMonth() == lastDayOfMonth) {
                if (currentMonth == Month.DECEMBER.getValue() && currentDate.getDayOfYear() == lastDayOfMonth) {
                    fillTypeField.set(obj, "Y");
                } else if (currentQuarter == 4 && currentDate.getDayOfYear() == lastDayOfMonth) {
                    fillTypeField.set(obj, "Q");
                } else {
                    fillTypeField.set(obj, "M");
                }
            }else{
                fillTypeField.set(obj, "D");
            }
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }


    }

    private static Field getField(Object obj, String fieldName){
        Class<?> clazz = obj.getClass();
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        } catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                field = getField(superclass, fieldName);
            }
        }
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }
}
