package com.artfess.reform.utils;

import java.math.BigDecimal;
import java.util.*;

public class CumputeUtil {

    // 三挡
    private BigDecimal[] gerar3 = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0.9"), new BigDecimal("0.8")};

    // 两档
    private BigDecimal[] gerar2 = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0.8")};

    // 小数保留位数
    private int scale = 2;

    // 是否按照最高档权重计算得分，true：按照最高档进行计算，false：按照最低档进行计算，默认true
    /**
     * 当计算达成率时将该值设置为false，其他业务保持默认即可
     */
    private boolean highest = true;


    /**
     * 测试主函数
     * @param args
     */
    public static void main(String[] args) {
        String path = ClassLoader.getSystemResource("excel/countyReport.xls").getPath();
        System.out.println("-----------------------计算得分测试-----------------------"+path);
        // 模拟数据1
       // BigDecimal[]  arr = new BigDecimal[]{new BigDecimal("0"), new BigDecimal("1"), new BigDecimal("48"),new BigDecimal("100"),new BigDecimal("0")};
        // 模拟数据2

       /* CumputeUtil cumputeUtil = new CumputeUtil(2);
        BigDecimal[] gerar00 = new BigDecimal[]{new BigDecimal("1"), new BigDecimal("0.8"), new BigDecimal("0.5")};
        BigDecimal a = cumputeUtil.cumpute3(arr, new BigDecimal("1"), new BigDecimal(20.0), gerar00,false);
        System.out.println(a);*/
        // 示例：自定义档位中权重
//
//
        // 示例：两档调用默认权重
//        BigDecimal b = cumputeUtil.cumpute2(arr2, new BigDecimal("30"), new BigDecimal(20.0));
    }



    /**
     *  三挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @return
     */
    public BigDecimal cumpute3(BigDecimal[] target, BigDecimal source, BigDecimal score) {
        if(null == gerar3 || gerar3.length < 3 || gerar3.length > 3){
            throw new RuntimeException("【三段权重值数组】参数不符合要求");
        }
        if(target==null || target.length==0){
            throw new RuntimeException("【三段权重值数组】比较的数据集合不能为空！");
        }
        if(source==null ){
            throw new RuntimeException("参与比较的数据不能为空！");
        }
        if(score==null || score.compareTo(new BigDecimal(0))==0){
            throw new RuntimeException("计算的总分值不能为空或为0！");
        }
        // 1.去重
        BigDecimal[] newTarget = duplicate(target);

        // 2.降序排序
        Arrays.sort(newTarget, Collections.reverseOrder());
        // 3.获取中位数
        BigDecimal median = median(newTarget);
        // 4.计算比值及结果
        // 4.1 如果所有数据都一样就直接按照最高档或者最低档计算
        if(newTarget.length < 2){
            if(this.highest){
                return this.gerar3[0].multiply(score);
            }else {
                if(source.compareTo(new BigDecimal(0))==0){
                    return new BigDecimal(0);
                }else{
                    return this.gerar3[this.gerar3.length - 1].multiply(score);
                }

            }
        }
        if(newTarget.length == 2){
            if(source.compareTo(newTarget[0]) == 0){
                return this.gerar3[0].multiply(score);
            }
            if(source.compareTo(newTarget[1]) == 0){
                return this.gerar3[this.gerar3.length - 1].multiply(score);
            }
        }
        if(source.compareTo(newTarget[0]) == 0){
            return this.gerar3[0].multiply(score);
        }
        if(source.compareTo(median) == 0){
            return this.gerar3[1].multiply(score);
        }
        if(source.compareTo(newTarget[newTarget.length - 1]) == 0){
            return this.gerar3[this.gerar3.length - 1].multiply(score);
        }
        BigDecimal v = source.subtract(median);
        BigDecimal u = newTarget[0].subtract(median);
        BigDecimal w = this.gerar3[0].subtract(this.gerar3[1]);
        BigDecimal x = this.gerar3[1];
        if(source.compareTo(median) < 0){
            BigDecimal min = newTarget[newTarget.length - 1];
            v= source.subtract(min);
            u = median.subtract(newTarget[newTarget.length - 1]);
            w = this.gerar3[1].subtract(this.gerar3[this.gerar3.length - 1]);
            x = this.gerar3[this.gerar3.length - 1];
        }
        BigDecimal a = v.divide(u, this.scale, BigDecimal.ROUND_HALF_UP);
        BigDecimal b = a.multiply(w).multiply(score);
        BigDecimal c = score.multiply(x);
        return b.add(c).stripTrailingZeros().setScale(scale, BigDecimal.ROUND_HALF_UP);
    }

    /**
     *  三挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @param gerar3 三段权重值数组
     * @param scale 小数保留位数，默认保留4位
     * @param highest 是否按照最高档权重计算得分，true：按照最高档进行计算，false：按照最低档进行计算，默认true
     * @return
     */
    public BigDecimal cumpute3(BigDecimal[] target, BigDecimal source, BigDecimal score, BigDecimal[] gerar3, int scale, Boolean highest) {
        this.gerar3 = gerar3;
        this.scale = scale;
        this.highest = highest;
        return this.cumpute3(target, source, score);
    }

    /**
     *  三挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @param gerar3 三段权重值数组
     * @param highest 是否按照最高档权重计算得分，true：按照最高档进行计算，false：按照最低档进行计算，默认true
     * @return
     */
    public BigDecimal cumpute3(BigDecimal[] target, BigDecimal source, BigDecimal score, BigDecimal[] gerar3, Boolean highest) {
        this.gerar3 = gerar3;
        this.highest = highest;
        return this.cumpute3(target, source, score);
    }

    /**
     *  三挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @param highest 是否按照最高档权重计算得分，true：按照最高档进行计算，false：按照最低档进行计算，默认true
     * @return
     */
    public BigDecimal cumpute3(BigDecimal[] target, BigDecimal source, BigDecimal score, Boolean highest) {
        this.highest = highest;
        return this.cumpute3(target, source, score);
    }

    /**
     *  两挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @param gerar2 三段权重值数组
     * @param scale 小数保留位数，默认保留4位
     * @param highest 当所有分值数（target数组）都一样时，是否按照最高档计算，true：是，false：否，
     * @return
     */
    public BigDecimal cumpute2(BigDecimal[] target, BigDecimal source, BigDecimal score, BigDecimal[] gerar2, int scale, Boolean highest) {
        this.gerar2 = gerar2;
        this.scale = scale;
        this.highest = highest;
        return this.cumpute2(target, source, score);
    }

    /**
     *  两挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @param scale 小数保留位数，默认保留4位
     * @param highest 当所有分值数（target数组）都一样时，是否按照最高档计算，true：是，false：否，
     * @return
     */
    public BigDecimal cumpute2(BigDecimal[] target, BigDecimal source, BigDecimal score, int scale, Boolean highest) {
        this.scale = scale;
        this.highest = highest;
        return this.cumpute2(target, source, score);
    }

    /**
     *  两挡分值计算公式，当计算百分比数据时用这个
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @param highest 当所有分值数（target数组）都一样时，是否按照最高档计算，true：是，false：否，
     * @return
     */
    public BigDecimal cumpute2(BigDecimal[] target, BigDecimal source, BigDecimal score,  Boolean highest) {;
        this.highest = highest;
        return this.cumpute2(target, source, score);
    }

    /**
     *  两挡分值计算公式
     * @param target 目标分值数组
     * @param source 当前分值
     * @param score 总分值
     * @return
     */
    public BigDecimal cumpute2(BigDecimal[] target, BigDecimal source, BigDecimal score) {
        if(null == gerar2 || gerar2.length < 2 || gerar2.length > 3){
            throw new RuntimeException("【两段权重值数组】参数不符合要求");
        }
        if(target==null || target.length==0){
            throw new RuntimeException("【两段权重值数组】比较的数据集合不能为空！");
        }
        if(source==null ){
            throw new RuntimeException("参与比较的数据不能为空！");
        }
        if(score==null || score.compareTo(new BigDecimal(0))==0){
            throw new RuntimeException("计算的总分值不能为空或为0！");
        }
        // 1.去重
        BigDecimal[] newTarget = duplicate(target);
        // 2.降序排序
        Arrays.sort(newTarget, Collections.reverseOrder());
        // 3.计算比值及结果
        // 3.1 如果所有数据都一样就直接按照最高档或者最低档计算
        if(newTarget.length < 2){
            if(this.highest){
                return this.gerar2[0].multiply(score);
            }else {
                if(source.compareTo(new BigDecimal(0))==0){
                    return new BigDecimal(0);
                }else{
                    return this.gerar2[this.gerar2.length - 1].multiply(score);
                }
            }
        }
        if(source.compareTo(newTarget[0]) == 0){
            return this.gerar2[0].multiply(score);
        }
        if(source.compareTo(newTarget[newTarget.length - 1]) == 0){
            return this.gerar2[this.gerar2.length - 1].multiply(score);
        }
        BigDecimal v = source.subtract(newTarget[newTarget.length - 1]);
        BigDecimal u = newTarget[0].subtract(newTarget[newTarget.length - 1]);
        BigDecimal w = this.gerar2[0].subtract(this.gerar2[this.gerar2.length - 1]);
        BigDecimal x = this.gerar2[this.gerar2.length - 1];
        BigDecimal a = v.divide(u, this.scale, BigDecimal.ROUND_HALF_UP);
        BigDecimal b = a.multiply(w).multiply(score);
        BigDecimal c = score.multiply(x);
        return b.add(c).stripTrailingZeros().setScale(scale, BigDecimal.ROUND_HALF_UP);
    }


    /**
     * 去重
     * @param arr
     * @return
     */
    public BigDecimal[] duplicate(BigDecimal[] arr){
        //实例化一个set集合
        Set set = new HashSet();
        //遍历数组并存入集合,如果元素已存在则不会重复存入
        for (int i = 0; i < arr.length; i++) {
            set.add(arr[i].stripTrailingZeros());
        }

        //返回Set集合的数组形式
        Object[] objectsArr = set.toArray();
        return Arrays.copyOf(objectsArr,objectsArr.length, BigDecimal[].class);
    }


    /**
     * 求出数组中位数，数组长度如果是基数就是中间数，如果是偶数就是中间两位数的平均数
     * @param arr
     * @return
     */
    public BigDecimal median(BigDecimal[] arr) {
        // 如果是偶数，则为中间两个数的和除以2
        if (arr.length % 2 == 0) {
            BigDecimal d = arr[arr.length / 2 - 1].add(arr[arr.length / 2]);
            return d.divide(new BigDecimal("2"), this.scale, BigDecimal.ROUND_HALF_UP);
        }
        // 否则就是中间这个数
        return arr[arr.length / 2];
    }

    public CumputeUtil(BigDecimal[] gerar3, BigDecimal[] gerar2, int scale) {
        this.gerar3 = gerar3;
        this.gerar2 = gerar2;
        this.scale = scale;
    }

    public CumputeUtil(int scale) {
        this.scale = scale;
    }

    public CumputeUtil(BigDecimal[] gerar3, int scale) {
        this.gerar3 = gerar3;
        this.scale = scale;
    }

    public CumputeUtil() {
    }

    public BigDecimal[] getGerar3() {
        return gerar3;
    }

    public void setGerar3(BigDecimal[] gerar3) {
        this.gerar3 = gerar3;
    }

    public BigDecimal[] getGerar2() {
        return gerar2;
    }

    public void setGerar2(BigDecimal[] gerar2) {
        this.gerar2 = gerar2;
    }

    public int getScale() {
        return scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isHighest() {
        return highest;
    }

    public void setHighest(boolean highest) {
        this.highest = highest;
    }
    
}
